/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.pmd.ruleset.java.comments.visitors;

import java.util.Iterator;
import java.util.LinkedList;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.body.JavadocComment;
import org.walkmod.javalang.visitors.VoidVisitorAdapter;
import org.walkmod.pmd.visitors.Modification;

@Modification
public class CommentsSize<T>
extends VoidVisitorAdapter<T> {
    private String violationSuppressRegex;
    private int maxLines = 6;
    private int maxLineLength = 80;

    public void visit(JavadocComment n, T ctx) {
        String content = n.getContent();
        boolean valid = true;
        if (content != null) {
            if (this.violationSuppressRegex != null) {
                valid = content.matches(this.violationSuppressRegex);
            }
            if (valid) {
                Iterator it;
                String[] lines = content.split("\\n");
                LinkedList<String> newLines = new LinkedList<String>();
                boolean requiredRewrite = false;
                for (int i = 0; i < lines.length; ++i) {
                    String line = lines[i].trim();
                    if (line.length() > this.maxLineLength) {
                        char[] letters = line.toCharArray();
                        int accum = 0;
                        int lastWhite = -1;
                        int begin = 0;
                        for (int j = 0; j < letters.length; ++j) {
                            if (letters[i] == ' ') {
                                lastWhite = i;
                            }
                            if (accum <= this.maxLineLength || lastWhite == -1) continue;
                            newLines.add(line.substring(begin, lastWhite - 1));
                            begin = lastWhite + 1;
                            requiredRewrite = true;
                        }
                        continue;
                    }
                    newLines.add(lines[i]);
                }
                String finalContent = "";
                if (newLines.size() > this.maxLines) {
                    it = newLines.iterator();
                    while (it.hasNext()) {
                        String line = (String)it.next();
                        if (line.length() <= 0 || line.trim().equals("*")) continue;
                        finalContent = finalContent + line;
                        if (!it.hasNext()) continue;
                        finalContent = finalContent + "\n";
                    }
                    if (finalContent.length() == 0) {
                        n.remove();
                    } else {
                        n.getParentNode().replaceChildNode((Node)n, (Node)new JavadocComment(finalContent));
                    }
                } else if (requiredRewrite) {
                    it = newLines.iterator();
                    while (it.hasNext()) {
                        finalContent = finalContent + (String)it.next();
                        if (!it.hasNext()) continue;
                        finalContent = finalContent + "\n";
                    }
                    n.getParentNode().replaceChildNode((Node)n, (Node)new JavadocComment(finalContent));
                }
            }
        }
    }

    public String getViolationSuppressRegex() {
        return this.violationSuppressRegex;
    }

    public void setViolationSuppressRegex(String violationSuppressRegex) {
        this.violationSuppressRegex = violationSuppressRegex;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setMaxLineLength(int maxLineLength) {
        this.maxLineLength = maxLineLength;
    }
}

