/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.pmd.ruleset.java.braces.visitors;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.stmt.BlockStmt;
import org.walkmod.javalang.ast.stmt.DoStmt;
import org.walkmod.javalang.ast.stmt.ForStmt;
import org.walkmod.javalang.ast.stmt.ForeachStmt;
import org.walkmod.javalang.ast.stmt.IfStmt;
import org.walkmod.javalang.ast.stmt.Statement;
import org.walkmod.javalang.ast.stmt.WhileStmt;
import org.walkmod.pmd.visitors.Modification;
import org.walkmod.pmd.visitors.PMDRuleVisitor;

@Modification
public class StatementsMustUseBraces
extends PMDRuleVisitor {
    private final EnumSet<Flag> flags;

    public StatementsMustUseBraces() {
        this.flags = EnumSet.allOf(Flag.class);
    }

    protected StatementsMustUseBraces(Flag flag) {
        this.flags = EnumSet.of(flag);
    }

    @Override
    public void visit(DoStmt n, Node arg) {
        if (this.flags.contains((Object)Flag.While) && !(n.getBody() instanceof BlockStmt)) {
            n.setBody((Statement)this.block(n.getBody()));
        }
        super.visit(n, arg);
    }

    private BlockStmt block(Statement statement) {
        return new BlockStmt(this.list(this.copy(statement)));
    }

    private <T extends Node> T copy(T n) {
        try {
            return (T)((Node)n.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private List<Statement> list(Statement statement) {
        ArrayList<Statement> statements = new ArrayList<Statement>(1);
        statements.add(statement);
        return statements;
    }

    @Override
    public void visit(ForeachStmt n, Node arg) {
        if (this.flags.contains((Object)Flag.For) && !(n.getBody() instanceof BlockStmt)) {
            n.setBody((Statement)this.block(n.getBody()));
        }
        super.visit(n, arg);
    }

    @Override
    public void visit(ForStmt n, Node arg) {
        if (this.flags.contains((Object)Flag.For) && !(n.getBody() instanceof BlockStmt)) {
            n.setBody((Statement)this.block(n.getBody()));
        }
        super.visit(n, arg);
    }

    @Override
    public void visit(IfStmt n, Node arg) {
        Statement elseStmt = n.getElseStmt();
        if (elseStmt == null) {
            if (this.flags.contains((Object)Flag.If) && !(n.getThenStmt() instanceof BlockStmt)) {
                n.setThenStmt((Statement)this.block(n.getThenStmt()));
            }
        } else if (this.flags.contains((Object)Flag.IfElse)) {
            if (!(n.getThenStmt() instanceof BlockStmt)) {
                n.setThenStmt((Statement)this.block(n.getThenStmt()));
            }
            if (!(elseStmt instanceof BlockStmt) && !(elseStmt instanceof IfStmt)) {
                n.setElseStmt((Statement)this.block(elseStmt));
            }
        }
        super.visit(n, arg);
    }

    @Override
    public void visit(WhileStmt n, Node arg) {
        if (this.flags.contains((Object)Flag.While) && !(n.getBody() instanceof BlockStmt)) {
            n.setBody((Statement)this.block(n.getBody()));
        }
        super.visit(n, arg);
    }

    static enum Flag {
        For,
        If,
        IfElse,
        While;

    }
}

