/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.pmd.ruleset.java.basic.visitors;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.BooleanLiteralExpr;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.stmt.BlockStmt;
import org.walkmod.javalang.ast.stmt.IfStmt;
import org.walkmod.javalang.ast.stmt.Statement;
import org.walkmod.pmd.visitors.Modification;
import org.walkmod.pmd.visitors.PMDRuleVisitor;

@Modification
public class UnconditionalIfStatement
extends PMDRuleVisitor {
    @Override
    public void visit(IfStmt n, Node ctx) {
        super.visit(n, ctx);
        Expression condition = n.getCondition();
        n = (IfStmt)ctx;
        if (condition instanceof BooleanLiteralExpr) {
            BooleanLiteralExpr literal = (BooleanLiteralExpr)condition;
            try {
                Node parent;
                if (literal.getValue() && (parent = n.getParentNode()) instanceof BlockStmt) {
                    BlockStmt block = (BlockStmt)parent;
                    List stmts = block.getStmts();
                    LinkedList<Statement> newStmts = new LinkedList<Statement>(stmts);
                    Iterator it = newStmts.iterator();
                    int i = 0;
                    int pos = -1;
                    while (it.hasNext() && pos == -1) {
                        Statement next = (Statement)it.next();
                        if (next == n) {
                            it.remove();
                            pos = i;
                        }
                        ++i;
                    }
                    if (pos != -1) {
                        Statement stmt = n.getThenStmt();
                        if (!(stmt instanceof BlockStmt)) {
                            newStmts.add(pos, n.getThenStmt().clone());
                        } else {
                            BlockStmt blockThen = (BlockStmt)stmt;
                            List stmtsList = blockThen.clone().getStmts();
                            newStmts.addAll(pos, stmtsList);
                        }
                    }
                    block.setStmts(newStmts);
                }
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

