/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.pmd.ruleset.java.basic.visitors;

import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.SymbolData;
import org.walkmod.javalang.ast.expr.AssignExpr;
import org.walkmod.javalang.ast.expr.BinaryExpr;
import org.walkmod.javalang.ast.expr.BooleanLiteralExpr;
import org.walkmod.javalang.ast.expr.ConditionalExpr;
import org.walkmod.javalang.ast.expr.EnclosedExpr;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.expr.NameExpr;
import org.walkmod.javalang.ast.expr.UnaryExpr;
import org.walkmod.javalang.compiler.symbols.RequiresSemanticAnalysis;
import org.walkmod.pmd.visitors.Modification;
import org.walkmod.pmd.visitors.PMDRuleVisitor;

@RequiresSemanticAnalysis
@Modification
public class SimplifiedTernary
extends PMDRuleVisitor {
    @Override
    public void visit(ConditionalExpr n, Node ctx) {
        SymbolData sdThen;
        super.visit(n, ctx);
        ConditionalExpr aux = (ConditionalExpr)ctx;
        Expression thenExpr = n.getThenExpr();
        Expression elseExpr = n.getElseExpr();
        if (thenExpr != null && elseExpr != null && (sdThen = thenExpr.getSymbolData()) != null && sdThen.getClazz().isAssignableFrom(Boolean.TYPE)) {
            Expression strippedThenExpr = SimplifiedTernary.stripEnclosed(thenExpr);
            Expression strippedElseExpr = SimplifiedTernary.stripEnclosed(elseExpr);
            if (strippedThenExpr instanceof BooleanLiteralExpr) {
                SimplifiedTernary.refactorLiteralThen(aux, ((BooleanLiteralExpr)strippedThenExpr).getValue(), strippedElseExpr);
            } else if (strippedElseExpr instanceof BooleanLiteralExpr) {
                SimplifiedTernary.refactorLiteralElse(aux, ((BooleanLiteralExpr)strippedElseExpr).getValue());
            }
        }
    }

    private static Expression stripEnclosed(Expression expr) {
        if (expr instanceof EnclosedExpr) {
            return SimplifiedTernary.stripEnclosed(((EnclosedExpr)expr).getInner());
        }
        return expr;
    }

    private static void refactorLiteralThen(ConditionalExpr aux, boolean thenValue, Expression strippedElseExpr) {
        if (thenValue) {
            BinaryExpr newNode;
            if (strippedElseExpr instanceof BooleanLiteralExpr) {
                boolean elseValue = ((BooleanLiteralExpr)strippedElseExpr).getValue();
                newNode = SimplifiedTernary.isAssignment(aux.getCondition()) && elseValue ? SimplifiedTernary.or(aux.getCondition(), (Expression)SimplifiedTernary.literalTrue()) : aux.getCondition();
            } else {
                newNode = SimplifiedTernary.or(aux.getCondition(), aux.getElseExpr());
            }
            aux.getParentNode().replaceChildNode((Node)aux, (Node)newNode);
        } else {
            boolean elseValue;
            Object newNode = strippedElseExpr instanceof BooleanLiteralExpr ? ((elseValue = ((BooleanLiteralExpr)strippedElseExpr).getValue()) ? SimplifiedTernary.not(aux.getCondition()) : (SimplifiedTernary.isAssignment(aux.getCondition()) ? SimplifiedTernary.and(aux.getCondition(), (Expression)SimplifiedTernary.literalFalse()) : SimplifiedTernary.literalFalse())) : SimplifiedTernary.and((Expression)SimplifiedTernary.not(aux.getCondition()), aux.getElseExpr());
            aux.getParentNode().replaceChildNode((Node)aux, (Node)newNode);
        }
    }

    private static boolean isAssignment(Expression expr) {
        return SimplifiedTernary.stripEnclosed(expr) instanceof AssignExpr;
    }

    private static BooleanLiteralExpr literalFalse() {
        return new BooleanLiteralExpr(false);
    }

    private static BooleanLiteralExpr literalTrue() {
        return new BooleanLiteralExpr(true);
    }

    private static UnaryExpr not(Expression condition) {
        return new UnaryExpr(SimplifiedTernary.encloseIfNeeded(condition), UnaryExpr.Operator.not);
    }

    private static BinaryExpr and(Expression e1, Expression e2) {
        return new BinaryExpr(e1, e2, BinaryExpr.Operator.and);
    }

    private static BinaryExpr or(Expression e1, Expression e2) {
        return new BinaryExpr(e1, e2, BinaryExpr.Operator.or);
    }

    private static void refactorLiteralElse(ConditionalExpr aux, boolean elseValue) {
        if (elseValue) {
            aux.getParentNode().replaceChildNode((Node)aux, (Node)SimplifiedTernary.or((Expression)SimplifiedTernary.not(aux.getCondition()), aux.getThenExpr()));
        } else {
            aux.getParentNode().replaceChildNode((Node)aux, (Node)SimplifiedTernary.and(aux.getCondition(), aux.getThenExpr()));
        }
    }

    private static Expression encloseIfNeeded(Expression expr) {
        return expr instanceof EnclosedExpr || expr instanceof NameExpr ? expr : new EnclosedExpr(expr);
    }
}

