/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.pmd.ruleset.java.basic.visitors;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.walkmod.javalang.ASTManager;
import org.walkmod.javalang.ast.ConstructorSymbolData;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.expr.FieldAccessExpr;
import org.walkmod.javalang.ast.expr.NameExpr;
import org.walkmod.javalang.ast.expr.ObjectCreationExpr;
import org.walkmod.javalang.ast.expr.StringLiteralExpr;
import org.walkmod.javalang.compiler.symbols.RequiresSemanticAnalysis;
import org.walkmod.pmd.visitors.Modification;
import org.walkmod.pmd.visitors.PMDRuleVisitor;

@RequiresSemanticAnalysis
@Modification
public class BigIntegerInstantiation
extends PMDRuleVisitor {
    private Map<String, String> integerConstants = new HashMap<String, String>();
    private Map<String, String> decimalConstants;

    public BigIntegerInstantiation() {
        this.integerConstants.put("0", "ZERO");
        this.integerConstants.put("1", "ONE");
        this.decimalConstants = new HashMap<String, String>();
        this.decimalConstants.put("0", "ZERO");
        this.decimalConstants.put("1", "ONE");
        this.decimalConstants.put("10", "TEN");
    }

    @Override
    public void visit(ObjectCreationExpr oce, Node ctx) {
        ObjectCreationExpr auxNode = (ObjectCreationExpr)ctx;
        ConstructorSymbolData sd = oce.getSymbolData();
        if (sd != null) {
            Expression arg;
            List args;
            String className = sd.getName();
            Map<String, String> mapping = null;
            if (className.equals(BigInteger.class.getName())) {
                mapping = this.integerConstants;
            } else if (className.equals(BigDecimal.class.getName())) {
                mapping = this.decimalConstants;
            }
            if (mapping != null && (args = auxNode.getArgs()) != null && args.size() == 1 && (arg = (Expression)args.get(0)) instanceof StringLiteralExpr) {
                StringLiteralExpr ile = (StringLiteralExpr)arg;
                String value = ile.getValue().replace('\"', '\u0000');
                try {
                    Node parent;
                    if (mapping.containsKey(value) && (parent = oce.getParentNode()) != null) {
                        NameExpr nexpr = (NameExpr)ASTManager.parse(NameExpr.class, (String)auxNode.getType().toString());
                        parent.replaceChildNode((Node)auxNode, (Node)new FieldAccessExpr((Expression)nexpr, mapping.get(value)));
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

