/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.pmd.ruleset.java.sunsecure.visitors;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.walkmod.javalang.ASTManager;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.body.BodyDeclaration;
import org.walkmod.javalang.ast.body.ClassOrInterfaceDeclaration;
import org.walkmod.javalang.ast.body.FieldDeclaration;
import org.walkmod.javalang.ast.body.MethodDeclaration;
import org.walkmod.javalang.ast.body.ModifierSet;
import org.walkmod.javalang.ast.body.VariableDeclarator;
import org.walkmod.javalang.ast.expr.ConditionalExpr;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.expr.FieldAccessExpr;
import org.walkmod.javalang.ast.expr.NameExpr;
import org.walkmod.javalang.ast.expr.ThisExpr;
import org.walkmod.javalang.ast.stmt.BlockStmt;
import org.walkmod.javalang.ast.stmt.ReturnStmt;
import org.walkmod.javalang.ast.stmt.Statement;
import org.walkmod.javalang.ast.type.ReferenceType;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.pmd.visitors.Modification;
import org.walkmod.pmd.visitors.PMDRuleVisitor;

@Modification
public class MethodReturnsInternalArray
extends PMDRuleVisitor {
    @Override
    public void visit(FieldDeclaration n, Node node) {
        List vds;
        FieldDeclaration aux = (FieldDeclaration)node;
        int modifiers = aux.getModifiers();
        if (ModifierSet.isPrivate((int)modifiers) && (vds = aux.getVariables()) != null && vds.size() == 1) {
            ClassOrInterfaceDeclaration clazz;
            MethodDeclaration getter;
            VariableDeclarator vd = (VariableDeclarator)vds.get(0);
            String variable = vd.getId().getName();
            Node parentNode = node.getParentNode();
            if ((this.isArray(aux.getType()) || vd.getId().getArrayCount() > 0) && parentNode instanceof ClassOrInterfaceDeclaration && (getter = this.lookupGetter(clazz = (ClassOrInterfaceDeclaration)parentNode, variable)) != null && this.exposesField(getter, variable)) {
                this.addCopyExpression(getter, variable);
            }
        }
    }

    private void addCopyExpression(MethodDeclaration getter, String variable) {
        List stmts = getter.getBody().getStmts();
        Statement stmt = (Statement)stmts.get(0);
        ReturnStmt returnStmt = (ReturnStmt)stmt;
        try {
            ConditionalExpr expr = (ConditionalExpr)ASTManager.parse(ConditionalExpr.class, (String)(variable + "==null?null:java.util.Arrays.copyOf(" + variable + "," + variable + ".length)"));
            returnStmt.setExpr((Expression)expr);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isArray(Type type) {
        if (type instanceof ReferenceType) {
            ReferenceType rtype = (ReferenceType)type;
            return rtype.getArrayCount() > 0;
        }
        return false;
    }

    private MethodDeclaration lookupGetter(ClassOrInterfaceDeclaration clazz, String variable) {
        if (!clazz.isInterface()) {
            List members = clazz.getMembers();
            MethodDeclaration getter = null;
            Iterator it = members.iterator();
            String label = StringUtils.capitalize((String)variable);
            while (it.hasNext() && getter == null) {
                String methodName;
                MethodDeclaration md;
                BodyDeclaration member = (BodyDeclaration)it.next();
                if (!(member instanceof MethodDeclaration) || !ModifierSet.isPublic((int)(md = (MethodDeclaration)member).getModifiers()) || !(methodName = md.getName()).equals("get" + label)) continue;
                getter = md;
            }
            return getter;
        }
        return null;
    }

    private boolean exposesField(MethodDeclaration md, String variable) {
        Statement stmt;
        BlockStmt block = md.getBody();
        List stmts = block.getStmts();
        if (stmts != null && stmts.size() == 1 && (md.getParameters() == null || md.getParameters().isEmpty()) && (stmt = (Statement)stmts.get(0)) instanceof ReturnStmt) {
            Expression scope;
            FieldAccessExpr fae;
            ReturnStmt returnStmt = (ReturnStmt)stmt;
            Expression expr = returnStmt.getExpr();
            if (expr instanceof NameExpr) {
                NameExpr nameExpr = (NameExpr)expr;
                return nameExpr.getName().equals(variable);
            }
            if (expr instanceof FieldAccessExpr && (fae = (FieldAccessExpr)expr).getField().equals(variable) && ((scope = fae.getScope()) == null || scope instanceof ThisExpr)) {
                return true;
            }
        }
        return false;
    }
}

