/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.pmd.ruleset.java.basic.visitors;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ASTManager;
import org.walkmod.javalang.ParseException;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.body.BodyDeclaration;
import org.walkmod.javalang.ast.body.ClassOrInterfaceDeclaration;
import org.walkmod.javalang.ast.body.MethodDeclaration;
import org.walkmod.javalang.ast.body.Parameter;
import org.walkmod.javalang.ast.body.VariableDeclaratorId;
import org.walkmod.javalang.ast.stmt.BlockStmt;
import org.walkmod.javalang.ast.type.ClassOrInterfaceType;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.visitors.VoidVisitor;
import org.walkmod.pmd.visitors.Addition;
import org.walkmod.pmd.visitors.PMDRuleVisitor;

@Addition
public class OverrideBothEqualsAndHashcode
extends PMDRuleVisitor {
    @Override
    public void visit(ClassOrInterfaceDeclaration coid, Node ctx) {
        ClassOrInterfaceDeclaration result = (ClassOrInterfaceDeclaration)ctx;
        if (!coid.isInterface()) {
            List members = coid.getMembers();
            List resultMembers = result.getMembers();
            boolean hasEquals = false;
            boolean hasHashCode = false;
            if (members != null) {
                MethodDeclaration md;
                Iterator it = members.iterator();
                Iterator itAux = resultMembers.iterator();
                while (!(!it.hasNext() || hasEquals && hasHashCode)) {
                    BodyDeclaration bd = (BodyDeclaration)it.next();
                    BodyDeclaration bdAux = (BodyDeclaration)itAux.next();
                    if (bd instanceof MethodDeclaration) {
                        MethodDeclaration md2 = (MethodDeclaration)bd;
                        List params = md2.getParameters();
                        String name = md2.getName();
                        if (name.equals("equals") && params != null && params.size() == 1) {
                            Parameter param = (Parameter)params.get(0);
                            Type type = param.getType();
                            String typeName = type.toString();
                            if (!typeName.equals("Object") && !typeName.equals("java.lang.Object")) continue;
                            hasEquals = true;
                            continue;
                        }
                        if (!name.equals("hashCode") || params != null && !params.isEmpty()) continue;
                        hasHashCode = true;
                        continue;
                    }
                    bd.accept((VoidVisitor)this, (Object)bdAux);
                }
                if (hasEquals && !hasHashCode) {
                    md = new MethodDeclaration();
                    md.setName("hashCode");
                    md.setModifiers(1);
                    md.setType((Type)new ClassOrInterfaceType("int"));
                    BlockStmt body = null;
                    try {
                        body = (BlockStmt)ASTManager.parse(BlockStmt.class, (String)"{ return super.hashCode(); }");
                    }
                    catch (ParseException e) {
                        throw new RuntimeException("Error generating hashCode method");
                    }
                    md.setBody(body);
                    resultMembers.add(md);
                } else if (!hasEquals && hasHashCode) {
                    md = new MethodDeclaration();
                    md.setName("equals");
                    md.setModifiers(1);
                    md.setType((Type)new ClassOrInterfaceType("boolean"));
                    LinkedList<Parameter> params = new LinkedList<Parameter>();
                    Parameter param = new Parameter((Type)new ClassOrInterfaceType("Object"), new VariableDeclaratorId("o"));
                    params.add(param);
                    md.setParameters(params);
                    BlockStmt body = null;
                    try {
                        body = (BlockStmt)ASTManager.parse(BlockStmt.class, (String)"{ return super.equals(o); }");
                    }
                    catch (ParseException e) {
                        throw new RuntimeException("Error generating equals method");
                    }
                    md.setBody(body);
                    resultMembers.add(md);
                }
            }
        }
    }
}

