/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.pmd.ruleset.java.basic.visitors;

import java.sql.ResultSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.SymbolData;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.body.MethodDeclaration;
import org.walkmod.javalang.ast.body.Parameter;
import org.walkmod.javalang.ast.body.VariableDeclarator;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.expr.MethodCallExpr;
import org.walkmod.javalang.ast.expr.VariableDeclarationExpr;
import org.walkmod.javalang.ast.stmt.BlockStmt;
import org.walkmod.javalang.ast.stmt.ExpressionStmt;
import org.walkmod.javalang.ast.stmt.IfStmt;
import org.walkmod.javalang.ast.stmt.Statement;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.compiler.symbols.RequiresSemanticAnalysis;
import org.walkmod.pmd.visitors.Modification;
import org.walkmod.pmd.visitors.PMDRuleVisitor;

@RequiresSemanticAnalysis
@Modification
public class CheckResultSet
extends PMDRuleVisitor {
    @Override
    public void visit(MethodDeclaration md, Node node) {
        super.visit(md, node);
        MethodDeclaration aux = (MethodDeclaration)node;
        List params = md.getParameters();
        List auxParams = aux.getParameters();
        if (params != null) {
            Iterator it = params.iterator();
            Iterator it2 = auxParams.iterator();
            while (it.hasNext()) {
                Parameter current = (Parameter)it.next();
                Parameter currentAux = (Parameter)it2.next();
                Type type = current.getType();
                SymbolData sd = type.getSymbolData();
                if (sd == null || !sd.getClazz().isAssignableFrom(ResultSet.class)) continue;
                this.updateStmts((SymbolDefinition)currentAux);
            }
        }
    }

    private void updateStmts(SymbolDefinition symbolDef) {
        List usages = symbolDef.getUsages();
        if (usages != null) {
            Iterator itUsages = usages.iterator();
            boolean updated = false;
            while (itUsages.hasNext() && !updated) {
                Node grandGrandParent;
                Node grandParent;
                MethodCallExpr mce;
                SymbolReference usage = (SymbolReference)itUsages.next();
                Node parent = ((Node)usage).getParentNode();
                if (!(parent instanceof MethodCallExpr) || !(mce = (MethodCallExpr)parent).getName().equals("next") || !((grandParent = mce.getParentNode()) instanceof ExpressionStmt) || !((grandGrandParent = grandParent.getParentNode()) instanceof BlockStmt) || !itUsages.hasNext()) continue;
                BlockStmt block = (BlockStmt)grandGrandParent;
                LinkedList<IfStmt> stmts = new LinkedList<IfStmt>(block.getStmts());
                LinkedList pendingBock = new LinkedList();
                Iterator itStmt = stmts.iterator();
                boolean removed = false;
                while (!removed && itStmt.hasNext()) {
                    Statement currentStmt = (Statement)itStmt.next();
                    if (currentStmt != grandParent || !itStmt.hasNext()) continue;
                    itStmt.remove();
                    while (itStmt.hasNext()) {
                        pendingBock.add(itStmt.next());
                        itStmt.remove();
                    }
                    removed = true;
                }
                if (removed) {
                    stmts.add(new IfStmt((Expression)mce, (Statement)new BlockStmt(pendingBock), null));
                }
                block.setStmts(stmts);
            }
        }
    }

    @Override
    public void visit(VariableDeclarationExpr vd, Node ctx) {
        super.visit(vd, ctx);
        VariableDeclarationExpr aux = (VariableDeclarationExpr)ctx;
        Type type = vd.getType();
        SymbolData sd = type.getSymbolData();
        if (sd != null && sd.getClazz().isAssignableFrom(ResultSet.class)) {
            List vars = vd.getVars();
            List vars2 = aux.getVars();
            if (vars != null) {
                for (VariableDeclarator currentVar : vars2) {
                    this.updateStmts((SymbolDefinition)currentVar);
                }
            }
        }
    }
}

