/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.pmd.ruleset.java.optimizations.visitors;

import java.util.Iterator;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.body.ModifierSet;
import org.walkmod.javalang.ast.body.VariableDeclarator;
import org.walkmod.javalang.ast.expr.AssignExpr;
import org.walkmod.javalang.ast.expr.EnclosedExpr;
import org.walkmod.javalang.ast.expr.UnaryExpr;
import org.walkmod.javalang.ast.expr.VariableDeclarationExpr;
import org.walkmod.javalang.ast.stmt.ExpressionStmt;
import org.walkmod.javalang.compiler.symbols.RequiresSemanticAnalysis;
import org.walkmod.pmd.visitors.PMDRuleVisitor;

@RequiresSemanticAnalysis
public class LocalVariableCouldBeFinal
extends PMDRuleVisitor {
    @Override
    public void visit(VariableDeclarationExpr n, Node context) {
        List vars;
        super.visit(n, context);
        VariableDeclarationExpr aux = (VariableDeclarationExpr)context;
        if (n.getParentNode() instanceof ExpressionStmt && (vars = n.getVars()) != null && !ModifierSet.isFinal((int)n.getModifiers())) {
            boolean areFinal = true;
            Iterator it = vars.iterator();
            while (it.hasNext() && areFinal) {
                VariableDeclarator vd = (VariableDeclarator)it.next();
                List usages = vd.getUsages();
                if (usages == null) continue;
                Iterator itUsages = usages.iterator();
                while (itUsages.hasNext() && areFinal) {
                    SymbolReference sr = (SymbolReference)itUsages.next();
                    Node srNode = (Node)sr;
                    areFinal = areFinal && !this.isAssigned(srNode);
                }
            }
            if (areFinal) {
                aux.setModifiers(ModifierSet.addModifier((int)n.getModifiers(), (int)16));
            }
        }
    }

    private boolean isAssigned(Node reference) {
        UnaryExpr ue;
        UnaryExpr.Operator op;
        Node parent = reference.getParentNode();
        while (parent instanceof EnclosedExpr) {
            parent = parent.getParentNode();
        }
        if (parent instanceof AssignExpr) {
            return true;
        }
        return parent instanceof UnaryExpr && ((op = (ue = (UnaryExpr)parent).getOperator()).equals((Object)UnaryExpr.Operator.posIncrement) || op.equals((Object)UnaryExpr.Operator.posDecrement) || op.equals((Object)UnaryExpr.Operator.preDecrement) || op.equals((Object)UnaryExpr.Operator.posDecrement));
    }
}

