/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.pmd.ruleset.java.design.visitors;

import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.BinaryExpr;
import org.walkmod.javalang.ast.expr.ConditionalExpr;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.expr.UnaryExpr;
import org.walkmod.javalang.ast.stmt.IfStmt;
import org.walkmod.javalang.ast.stmt.Statement;
import org.walkmod.javalang.visitors.VoidVisitor;
import org.walkmod.pmd.visitors.PMDRuleVisitor;

public class ConfusingTernary
extends PMDRuleVisitor {
    @Override
    public void visit(IfStmt n, Node context) {
        Expression e;
        if (context instanceof IfStmt && (e = (n = (IfStmt)context).getCondition()) instanceof BinaryExpr) {
            if (this.isNegative(e) && n.getElseStmt() != null) {
                try {
                    IfStmt newIfStmt = n.clone();
                    BinaryExpr bexpr = (BinaryExpr)newIfStmt.getCondition();
                    this.negate((Expression)bexpr);
                    Statement then = newIfStmt.getThenStmt();
                    newIfStmt.setThenStmt(n.getElseStmt());
                    newIfStmt.setElseStmt(then);
                    context.getParentNode().replaceChildNode(context, (Node)newIfStmt);
                    n.getThenStmt().accept((VoidVisitor)this, (Object)newIfStmt.getElseStmt());
                    n.getElseStmt().accept((VoidVisitor)this, (Object)newIfStmt.getThenStmt());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
            } else {
                super.visit(n, context);
            }
        }
    }

    private boolean isNegative(Expression n) {
        if (n instanceof UnaryExpr) {
            UnaryExpr aux = (UnaryExpr)n;
            return aux.getOperator().equals((Object)UnaryExpr.Operator.not);
        }
        if (n instanceof BinaryExpr) {
            BinaryExpr be = (BinaryExpr)n;
            BinaryExpr.Operator op = be.getOperator();
            if (op.equals((Object)BinaryExpr.Operator.notEquals)) {
                return true;
            }
            if (op.equals((Object)BinaryExpr.Operator.and)) {
                return this.isNegative(be.getRight()) && this.isNegative(be.getLeft());
            }
        }
        return false;
    }

    private void negate(Expression n) {
        if (n instanceof UnaryExpr) {
            UnaryExpr aux = (UnaryExpr)n;
            n.getParentNode().replaceChildNode((Node)aux, (Node)aux.getExpr());
        } else if (n instanceof BinaryExpr) {
            BinaryExpr be = (BinaryExpr)n;
            BinaryExpr.Operator op = be.getOperator();
            if (op.equals((Object)BinaryExpr.Operator.notEquals)) {
                be.setOperator(BinaryExpr.Operator.equals);
            } else if (op.equals((Object)BinaryExpr.Operator.and)) {
                be.setOperator(BinaryExpr.Operator.or);
                this.negate(be.getRight());
                this.negate(be.getLeft());
            }
        }
    }

    @Override
    public void visit(ConditionalExpr n, Node context) {
        if (context instanceof ConditionalExpr) {
            ConditionalExpr aux = (ConditionalExpr)context;
            if (this.isNegative(n.getCondition()) && aux.getElseExpr() != null) {
                try {
                    ConditionalExpr copy = aux.clone();
                    this.negate(copy.getCondition());
                    Expression thenExpr = copy.getThenExpr();
                    copy.setThenExpr(copy.getElseExpr());
                    copy.setElseExpr(thenExpr);
                    context.getParentNode().replaceChildNode(context, (Node)copy);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
            }
        }
    }
}

