/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.pmd.visitors;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.RuleSetFactory;
import org.walkmod.javalang.ast.CompilationUnit;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.compiler.symbols.RequiresSemanticAnalysis;
import org.walkmod.javalang.visitors.CloneVisitor;
import org.walkmod.javalang.visitors.VoidVisitorAdapter;
import org.walkmod.pmd.visitors.PMDRuleVisitor;
import org.walkmod.walkers.VisitorContext;

@RequiresSemanticAnalysis
public class PMDVisitor
extends VoidVisitorAdapter<VisitorContext> {
    private String configurationfile;
    private RuleSet rules = new RuleSet();
    private List<Rule> fixingRules = new LinkedList<Rule>();
    private List<PMDRuleVisitor> visitors = null;
    private boolean splitExecution = false;

    private void parseCfg(String config) throws Exception {
        RuleSetFactory factory = new RuleSetFactory();
        this.rules = factory.createRuleSet(config);
    }

    public void visit(CompilationUnit cu, VisitorContext ctx) {
        if (this.rules != null) {
            if (this.visitors == null) {
                this.visitors = new LinkedList<PMDRuleVisitor>();
                for (Rule rule : this.rules.getRules()) {
                    Object o = null;
                    if (rule.getLanguage().getName().toLowerCase().equals("java")) {
                        try {
                            Class<?> c = Class.forName("org.walkmod.pmd.ruleset.java." + rule.getRuleSetName().toLowerCase() + ".visitors." + rule.getName(), true, ctx.getClassLoader());
                            o = c.newInstance();
                        }
                        catch (Exception c) {
                            // empty catch block
                        }
                    }
                    if (!(o instanceof PMDRuleVisitor)) continue;
                    this.visitors.add(o);
                    this.fixingRules.add(rule);
                }
            }
            Iterator<Rule> it = this.fixingRules.iterator();
            for (PMDRuleVisitor visitor : this.visitors) {
                if (this.splitExecution) {
                    CompilationUnit aux = (CompilationUnit)new CloneVisitor().visit(cu, (Object)ctx);
                    visitor.visit(cu, (Node)aux);
                    if (it.hasNext()) {
                        Rule rule = it.next();
                        HashMap<String, String> data = new HashMap<String, String>();
                        data.put("cause", "pmd.java." + rule.getRuleSetName() + "." + rule.getName());
                        aux.setData(data);
                    }
                    ctx.addResultNode((Object)aux);
                    continue;
                }
                visitor.visit(cu, null);
            }
        }
    }

    public RuleSet getRules() {
        return this.rules;
    }

    public void setConfigurationFile(String configurationFile) throws Exception {
        this.configurationfile = configurationFile;
        this.parseCfg(this.configurationfile);
    }

    public void setVisitors(List<PMDRuleVisitor> list) {
        this.visitors = list;
    }

    public void setSplitExecution(boolean splitExecution) {
        this.splitExecution = splitExecution;
    }
}

