/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.pmd.ruleset.java.basic.visitors;

import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.IntegerLiteralExpr;
import org.walkmod.pmd.visitors.PMDRuleVisitor;

public class AvoidUsingOctalValues
extends PMDRuleVisitor {
    @Override
    public void visit(IntegerLiteralExpr n, Node ctx) {
        super.visit(n, ctx);
        IntegerLiteralExpr aux = (IntegerLiteralExpr)ctx;
        String s = aux.getValue();
        if (s.startsWith("0") && s.length() > 1) {
            char[] digits = s.toCharArray();
            int value = 0;
            int power = 1;
            boolean isOctal = true;
            for (int i = digits.length - 1; i >= 0 && isOctal; --i) {
                isOctal = Character.isDigit(digits[i]);
                if (!isOctal) continue;
                Integer digit = Integer.parseInt(Character.toString(digits[i]));
                isOctal = digit <= 7;
                value += digit * power;
                power *= 8;
            }
            if (isOctal) {
                aux.setValue(Integer.toString(value));
            }
        }
    }
}

