/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.pmd.ruleset.java.basic.visitors;

import org.walkmod.javalang.ast.FieldSymbolData;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.SymbolDataAware;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.expr.BinaryExpr;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.expr.FieldAccessExpr;
import org.walkmod.javalang.ast.expr.NameExpr;
import org.walkmod.javalang.ast.expr.NullLiteralExpr;
import org.walkmod.javalang.compiler.symbols.RequiresSemanticAnalysis;
import org.walkmod.javalang.visitors.VoidVisitor;
import org.walkmod.javalang.visitors.VoidVisitorAdapter;
import org.walkmod.pmd.visitors.AbstractPMDRuleVisitor;

@RequiresSemanticAnalysis
public class MisplacedNullCheck<T>
extends AbstractPMDRuleVisitor<T> {
    @Override
    public void visit(BinaryExpr n, T ctx) {
        BinaryExpr.Operator op = n.getOperator();
        if (op.equals((Object)BinaryExpr.Operator.notEquals) || op.equals((Object)BinaryExpr.Operator.equals)) {
            Expression right = n.getRight();
            Expression left = n.getLeft();
            Node parent = n.getParentNode();
            if (parent instanceof BinaryExpr) {
                BinaryExpr bo = (BinaryExpr)parent;
                if (right instanceof NullLiteralExpr) {
                    if (left instanceof NameExpr) {
                        if (bo.getRight() == n) {
                            ReorderCondition visitor = new ReorderCondition((NameExpr)left);
                            bo.getLeft().accept((VoidVisitor)visitor, (Object)bo);
                        }
                    } else if (left instanceof FieldAccessExpr && bo.getRight() == n) {
                        ReorderCondition visitor = new ReorderCondition((FieldAccessExpr)left);
                        bo.getLeft().accept((VoidVisitor)visitor, (Object)bo);
                    }
                } else if (left instanceof NullLiteralExpr) {
                    if (right instanceof NameExpr) {
                        if (bo.getRight() == n) {
                            ReorderCondition visitor = new ReorderCondition((NameExpr)right);
                            bo.getLeft().accept((VoidVisitor)visitor, (Object)bo);
                        }
                    } else if (right instanceof FieldAccessExpr && bo.getRight() == n) {
                        ReorderCondition visitor = new ReorderCondition((FieldAccessExpr)right);
                        bo.getLeft().accept((VoidVisitor)visitor, (Object)bo);
                    }
                }
            }
        } else {
            super.visit(n, ctx);
        }
    }

    private class ReorderCondition
    extends VoidVisitorAdapter<BinaryExpr> {
        private SymbolReference referredExpression;

        public ReorderCondition(NameExpr referredExpression) {
            this.referredExpression = referredExpression;
        }

        public ReorderCondition(FieldAccessExpr referredExpression) {
            this.referredExpression = referredExpression;
        }

        public void visit(NameExpr n, BinaryExpr ctx) {
            this.replace((SymbolReference)n, ctx);
        }

        private void replace(SymbolReference n, BinaryExpr ctx) {
            SymbolDefinition sd = n.getSymbolDefinition();
            boolean valid = false;
            if (sd != null && sd == this.referredExpression.getSymbolDefinition()) {
                SymbolReference srParent = null;
                SymbolReference srParentRef = null;
                Expression parentNode = null;
                if (n instanceof FieldAccessExpr && (parentNode = ((FieldAccessExpr)n).getScope()) != null && parentNode instanceof SymbolReference) {
                    srParent = (SymbolReference)parentNode;
                }
                if (this.referredExpression instanceof FieldAccessExpr && (parentNode = ((FieldAccessExpr)this.referredExpression).getScope()) != null && parentNode instanceof SymbolReference) {
                    srParentRef = (SymbolReference)parentNode;
                }
                boolean bl = valid = srParent == null && srParentRef == null || srParent != null && srParentRef != null && srParent.getSymbolDefinition() == srParentRef.getSymbolDefinition();
            }
            if (sd == null && this.referredExpression.getSymbolDefinition() == null && n instanceof SymbolDataAware && this.referredExpression instanceof SymbolDataAware) {
                SymbolDataAware sda = (SymbolDataAware)n;
                SymbolDataAware sda2 = (SymbolDataAware)this.referredExpression;
                if (sda.getSymbolData() instanceof FieldSymbolData && sda2.getSymbolData() instanceof FieldSymbolData) {
                    FieldSymbolData fsd = (FieldSymbolData)sda.getSymbolData();
                    FieldSymbolData fsd2 = (FieldSymbolData)sda2.getSymbolData();
                    valid = fsd.getField().equals(fsd2.getField());
                }
            }
            if (valid) {
                Expression left = ctx.getLeft();
                Expression right = ctx.getRight();
                ctx.setRight(left);
                ctx.setLeft(right);
            }
        }

        public void visit(FieldAccessExpr n, BinaryExpr ctx) {
            this.replace((SymbolReference)n, ctx);
        }
    }
}

