/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.override.visitors;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.MethodSymbolData;
import org.walkmod.javalang.ast.SymbolData;
import org.walkmod.javalang.ast.body.MethodDeclaration;
import org.walkmod.javalang.ast.body.ModifierSet;
import org.walkmod.javalang.ast.body.Parameter;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.expr.MarkerAnnotationExpr;
import org.walkmod.javalang.ast.expr.NameExpr;
import org.walkmod.javalang.compiler.reflection.ClassInspector;
import org.walkmod.javalang.compiler.reflection.MethodInspector;
import org.walkmod.javalang.compiler.symbols.RequiresSemanticAnalysis;
import org.walkmod.javalang.visitors.VoidVisitorAdapter;
import org.walkmod.walkers.VisitorContext;

@RequiresSemanticAnalysis
public class OverrideVisitor
extends VoidVisitorAdapter<VisitorContext> {
    private boolean containsOverrideAsAnnotationExpr(MethodDeclaration md) {
        List mAnnotations = md.getAnnotations();
        boolean containsOverride = false;
        if (mAnnotations != null) {
            Iterator it = mAnnotations.iterator();
            while (it.hasNext() && !containsOverride) {
                AnnotationExpr ae = (AnnotationExpr)it.next();
                SymbolData sd = ae.getSymbolData();
                if (sd == null) continue;
                Class clazz = sd.getClazz();
                containsOverride = clazz.equals(Override.class);
            }
        }
        return containsOverride;
    }

    private boolean containsOverrideInByteCode(MethodDeclaration md) {
        boolean isAnnotationPresent = true;
        MethodSymbolData sdata = md.getSymbolData();
        Method method = sdata.getMethod();
        try {
            isAnnotationPresent = method.isAnnotationPresent(Override.class);
        }
        catch (Throwable t) {
            // empty catch block
        }
        return isAnnotationPresent;
    }

    private boolean containsAnEquivalentParentMethod(MethodDeclaration md) {
        MethodSymbolData sdata = md.getSymbolData();
        boolean result = false;
        if (sdata != null) {
            Class<?> declaringClass;
            Class<?> parentClass;
            Method method = sdata.getMethod();
            if (!this.containsOverrideAsAnnotationExpr(md) && !this.containsOverrideInByteCode(md) && (parentClass = (declaringClass = method.getDeclaringClass()).getSuperclass()) != null) {
                List params = md.getParameters();
                SymbolData[] args = null;
                if (params != null) {
                    args = new SymbolData[params.size()];
                    int i = 0;
                    for (Parameter param : params) {
                        args[i] = param.getType().getSymbolData();
                        ++i;
                    }
                } else {
                    args = new SymbolData[]{};
                }
                LinkedList scopesToCheck = new LinkedList();
                scopesToCheck.add(parentClass);
                Class<?>[] interfaces = declaringClass.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    scopesToCheck.add(interfaces[i]);
                }
                Iterator it = scopesToCheck.iterator();
                Method foundMethod = null;
                while (it.hasNext() && foundMethod == null) {
                    Class clazzToAnalyze = (Class)it.next();
                    foundMethod = MethodInspector.findMethod((Class)clazzToAnalyze, (SymbolData[])args, (String)md.getName());
                    if (foundMethod == null) continue;
                    List types = ClassInspector.getInterfaceOrSuperclassImplementations(declaringClass, (Class)clazzToAnalyze);
                    Class implementation = null;
                    if (types != null && !types.isEmpty() && types.get(0) instanceof Class) {
                        implementation = (Class)types.get(0);
                    }
                    Type[] parameterTypes = foundMethod.getGenericParameterTypes();
                    int modifiers = foundMethod.getModifiers();
                    boolean valid = ModifierSet.isPublic((int)modifiers) || ModifierSet.isProtected((int)modifiers);
                    for (int i = 0; i < parameterTypes.length && valid; ++i) {
                        if (parameterTypes[i] instanceof Class) {
                            valid = args[i].getClazz().getName().equals(((Class)parameterTypes[i]).getName());
                            continue;
                        }
                        if (!(parameterTypes[i] instanceof TypeVariable)) continue;
                        TypeVariable tv = (TypeVariable)parameterTypes[i];
                        if (implementation == null) continue;
                        TypeVariable<Class<T>>[] tvs = implementation.getTypeParameters();
                        int pos = -1;
                        for (int k = 0; k < tvs.length && pos == -1; ++k) {
                            if (!tvs[k].getName().equals(tv.getName())) continue;
                            pos = k;
                        }
                        if (pos <= -1) continue;
                        Type[] bounds = tvs[pos].getBounds();
                        for (int k = 0; k < bounds.length && valid; ++k) {
                            if (!(bounds[k] instanceof Class)) continue;
                            valid = args[i].getClazz().isAssignableFrom((Class)bounds[k]);
                        }
                    }
                    if (valid) continue;
                    foundMethod = null;
                }
                result = foundMethod != null;
            }
        }
        return result;
    }

    public void visit(MethodDeclaration md, VisitorContext arg) {
        if (!ModifierSet.isStatic((int)md.getModifiers()) && !ModifierSet.isPrivate((int)md.getModifiers()) && this.containsAnEquivalentParentMethod(md)) {
            LinkedList<MarkerAnnotationExpr> annotations = md.getAnnotations();
            if (annotations == null) {
                annotations = new LinkedList<MarkerAnnotationExpr>();
                md.setAnnotations(annotations);
            }
            annotations.add(new MarkerAnnotationExpr(new NameExpr("Override")));
        }
        super.visit(md, (Object)arg);
    }
}

