/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.override.visitors;

import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.MethodSymbolData;
import org.walkmod.javalang.ast.SymbolData;
import org.walkmod.javalang.ast.body.MethodDeclaration;
import org.walkmod.javalang.ast.body.Parameter;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.expr.MarkerAnnotationExpr;
import org.walkmod.javalang.ast.expr.NameExpr;
import org.walkmod.javalang.compiler.reflection.MethodInspector;
import org.walkmod.javalang.compiler.symbols.RequiresSemanticAnalysis;
import org.walkmod.javalang.visitors.VoidVisitorAdapter;
import org.walkmod.walkers.VisitorContext;

@RequiresSemanticAnalysis
public class OverrideVisitor
extends VoidVisitorAdapter<VisitorContext> {
    public void visit(MethodDeclaration md, VisitorContext arg) {
        MethodSymbolData sdata = md.getSymbolData();
        if (sdata != null) {
            Class<?> declaringClass;
            Class<?> parentClass;
            Method method = sdata.getMethod();
            List mAnnotations = md.getAnnotations();
            boolean containsOverride = false;
            if (mAnnotations != null) {
                Iterator it = mAnnotations.iterator();
                while (it.hasNext() && !containsOverride) {
                    AnnotationExpr ae = (AnnotationExpr)it.next();
                    SymbolData sd = ae.getSymbolData();
                    if (sd == null) continue;
                    Class clazz = sd.getClazz();
                    containsOverride = clazz.equals(Override.class);
                }
            }
            if (!containsOverride && !method.isAnnotationPresent(Override.class) && (parentClass = (declaringClass = method.getDeclaringClass()).getSuperclass()) != null) {
                List params = md.getParameters();
                SymbolData[] args = null;
                if (params != null) {
                    args = new SymbolData[params.size()];
                    int i = 0;
                    for (Parameter param : params) {
                        args[i] = param.getType().getSymbolData();
                        ++i;
                    }
                } else {
                    args = new SymbolData[]{};
                }
                LinkedList scopesToCheck = new LinkedList();
                scopesToCheck.add(parentClass);
                Class<?>[] interfaces = declaringClass.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    scopesToCheck.add(interfaces[i]);
                }
                Iterator it = scopesToCheck.iterator();
                boolean found = false;
                while (it.hasNext() && !found) {
                    found = MethodInspector.findMethod((Class)((Class)it.next()), (SymbolData[])args, (String)md.getName()) != null;
                }
                if (found) {
                    LinkedList<MarkerAnnotationExpr> annotations = md.getAnnotations();
                    if (annotations == null) {
                        annotations = new LinkedList<MarkerAnnotationExpr>();
                        md.setAnnotations(annotations);
                    }
                    annotations.add(new MarkerAnnotationExpr(new NameExpr("Override")));
                }
            }
        }
        super.visit(md, (Object)arg);
    }
}

