/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.importscleaner.visitors;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.walkmod.javalang.JavadocManager;
import org.walkmod.javalang.ast.CompilationUnit;
import org.walkmod.javalang.ast.ImportDeclaration;
import org.walkmod.javalang.ast.body.JavadocComment;
import org.walkmod.javalang.ast.body.JavadocTag;
import org.walkmod.javalang.ast.expr.NameExpr;
import org.walkmod.javalang.ast.type.ClassOrInterfaceType;
import org.walkmod.javalang.visitors.VoidVisitorAdapter;
import org.walkmod.walkers.VisitorContext;

public class ImportsOrganizer
extends VoidVisitorAdapter<VisitorContext> {
    private Set<String> referencedTypes;
    private static Logger log = Logger.getLogger(ImportsOrganizer.class);

    public void visit(ClassOrInterfaceType n, VisitorContext ctx) {
        if (n.getScope() != null) {
            this.referencedTypes.add(String.valueOf(n.getScope().toString()) + "." + n.getName());
            this.referencedTypes.add(n.getScope().toString());
        } else {
            this.referencedTypes.add(n.getName());
        }
        super.visit(n, (Object)ctx);
    }

    public void visit(NameExpr n, VisitorContext ctx) {
        this.referencedTypes.add(n.toString());
        super.visit(n, (Object)ctx);
    }

    public void visit(JavadocComment n, VisitorContext ctx) {
        try {
            List tags = JavadocManager.parse((String)n.getContent());
            if (tags != null) {
                for (JavadocTag tag : tags) {
                    String typeName;
                    String type;
                    List values;
                    String name = tag.getName();
                    if ("@link".equals(name) || "@linkplain".equals(name) || "@throws".equals(name)) {
                        values = tag.getValues();
                        if (values == null || (type = (String)values.get(0)) == null || "".equals(typeName = type.split("#")[0])) continue;
                        this.referencedTypes.add(typeName);
                        continue;
                    }
                    if (!"@see".equals(name) || (values = tag.getValues()) == null || (type = (String)values.get(0)) == null || type.startsWith("<") || type.startsWith("\"") || "".equals(typeName = type.split("#")[0])) continue;
                    this.referencedTypes.add(typeName);
                }
            }
        }
        catch (Exception e) {
            log.warn((Object)("Parsing error in the javadoc " + n.getContent()));
        }
    }

    public void visit(CompilationUnit n, VisitorContext ctx) {
        this.referencedTypes = new HashSet<String>();
        super.visit(n, (Object)ctx);
        List imports = n.getImports();
        if (imports != null && !this.referencedTypes.isEmpty()) {
            LinkedList cleanImportList = new LinkedList(imports);
            Iterator itImport = cleanImportList.iterator();
            while (itImport.hasNext()) {
                ImportDeclaration id = (ImportDeclaration)itImport.next();
                if (id.isStatic() || id.isAsterisk()) continue;
                boolean found = false;
                String importName = id.getName().toString();
                Iterator<String> it = this.referencedTypes.iterator();
                while (it.hasNext() && !found) {
                    String name = it.next();
                    int dotIndex = name.indexOf(".");
                    name = dotIndex != -1 ? name.substring(dotIndex) : "." + name;
                    found = importName.endsWith(name);
                }
                if (found) continue;
                itImport.remove();
                log.debug((Object)("Removed " + importName));
            }
            n.setImports(cleanImportList);
        }
    }

    public Set<String> getReferencedTypes() {
        return this.referencedTypes;
    }
}

