/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.gradle.providers;

import com.alibaba.fastjson.JSONArray;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.ExternalDependency;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.EclipseProjectDependency;
import org.walkmod.conf.ConfigurationException;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.Configuration;

public class ClassLoaderConfigurationProvider
implements ConfigurationProvider {
    private File pomFile = null;
    private String buildDir = "classes";
    private Configuration configuration;
    private String installationDir;
    private String userHomeDir;
    private String workingDirectory;
    private String task = "assemble";
    private String flavor = null;
    private GradleConnector connector = null;
    private String gradleVersion = null;
    private JSONArray localLibs = null;

    public void setInstallationDir(String installationDir) {
        this.installationDir = installationDir;
    }

    public void setUserHomeDir(String userHomeDir) {
        this.userHomeDir = userHomeDir;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setLocalLibs(JSONArray localLibs) {
        this.localLibs = localLibs;
    }

    public void setBuildDir(String buildDir) {
        this.buildDir = buildDir;
    }

    public String getBuildDir() {
        return this.buildDir;
    }

    public void setFlavor(String flavor) {
        this.flavor = flavor;
    }

    public File getPomFile() {
        return this.pomFile;
    }

    public void setPomFile(File file) {
        this.pomFile = file;
    }

    public void setGradleVersion(String gradleVersion) {
        this.gradleVersion = gradleVersion;
    }

    public void init(Configuration configuration) {
        this.configuration = configuration;
    }

    public GradleConnector getConnector() throws ConfigurationException {
        if (this.connector == null) {
            this.connector = GradleConnector.newConnector();
            if (this.gradleVersion != null) {
                this.connector.useGradleVersion(this.gradleVersion);
            }
            if (this.installationDir != null) {
                this.connector.useInstallation(new File(this.installationDir));
                if (this.userHomeDir != null) {
                    this.connector.useGradleUserHomeDir(new File(this.userHomeDir));
                } else {
                    try {
                        this.userHomeDir = new File(System.getProperty("user.home"), ".gradle").getCanonicalPath();
                    }
                    catch (IOException e) {
                        throw new ConfigurationException("Error resolving the working directory", e.getCause());
                    }
                }
            } else {
                try {
                    this.userHomeDir = new File(System.getProperty("user.home"), ".gradle").getCanonicalPath();
                }
                catch (IOException e) {
                    throw new ConfigurationException("Error resolving the working directory", e.getCause());
                }
            }
            if (this.workingDirectory == null) {
                try {
                    this.workingDirectory = new File(".").getCanonicalPath();
                }
                catch (IOException e) {
                    throw new ConfigurationException("Error resolving the working directory", e.getCause());
                }
            }
            this.connector.forProjectDirectory(new File(this.workingDirectory));
        }
        return this.connector;
    }

    public void compile() throws Exception {
        ProjectConnection connection = this.getConnector().connect();
        try {
            BuildLauncher launcher = connection.newBuild();
            if (this.flavor != null) {
                launcher.forTasks(new String[]{this.task + StringUtils.capitalize((String)this.flavor)});
            } else {
                launcher.forTasks(new String[]{this.task});
            }
            launcher.setStandardOutput((OutputStream)System.out);
            launcher.setStandardError((OutputStream)System.err);
            launcher.run();
        }
        finally {
            connection.close();
        }
    }

    private List<String> getDepsCoordinates(ProjectConnection connection) {
        BuildLauncher launcher = connection.newBuild();
        launcher.forTasks(new String[]{"dependencies"});
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        launcher.setStandardOutput((OutputStream)bos);
        launcher.setStandardError((OutputStream)System.err);
        launcher.run();
        String content = bos.toString();
        String[] lines = content.split("\\n");
        LinkedList<String> coordinates = new LinkedList<String>();
        for (int i = 0; i < lines.length; ++i) {
            if (!lines[i].startsWith("compile") && !lines[i].startsWith("provided") || i + 1 >= lines.length || lines[i + 1].startsWith("No dependencies")) continue;
            int j = i + 1;
            String prefix = null;
            String nextGoal = "debugApk";
            if (lines[i].startsWith("provided")) {
                nextGoal = "releaseApk";
            }
            while (j < lines.length && !lines[j].startsWith(nextGoal)) {
                int index = lines[j].lastIndexOf("--");
                if (index != -1) {
                    String artifact;
                    prefix = lines[j].substring(0, index + 2);
                    if (lines[j].length() > prefix.length() && !(artifact = lines[j].substring(prefix.length()).trim()).endsWith("(*)")) {
                        int dynamicVersionIndex = artifact.indexOf("->");
                        if (dynamicVersionIndex != -1) {
                            String artifactName = artifact.substring(0, artifact.lastIndexOf(":")).trim();
                            String version = artifact.substring(dynamicVersionIndex + 2).trim();
                            artifact = artifactName + ":" + version;
                        }
                        coordinates.add(artifact);
                    }
                }
                ++j;
            }
        }
        return coordinates;
    }

    private Integer getCompileAndroidSDKVersion(File projectDir) {
        File cfg = new File(projectDir, "build.gradle");
        Integer version = null;
        Integer compileSDKVersion = null;
        try {
            List cfgContent = FileUtils.readLines((File)cfg);
            Iterator it = cfgContent.iterator();
            while (it.hasNext() && compileSDKVersion == null) {
                String line = (String)it.next();
                int index = line.indexOf("minSdkVersion ");
                if (index != -1) {
                    version = Integer.parseInt(line.substring(index + "minSdkVersion ".length()).trim());
                    continue;
                }
                index = line.indexOf("compileSdkVersion ");
                if (index == -1) continue;
                compileSDKVersion = Integer.parseInt(line.substring(index + "compileSdkVersion ".length()).trim());
            }
            if (compileSDKVersion != null) {
                version = compileSDKVersion;
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading the build.gradle", e.getCause());
        }
        return version;
    }

    private File getAndroidJar(Integer version) {
        File jarDir;
        String androidHome = System.getenv("ANDROID_HOME");
        if (androidHome != null && !"".equals(androidHome) && (jarDir = new File(androidHome, "platforms/")).exists()) {
            Integer versionNumber = null;
            File[] files = jarDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String fileName = files[i].getName();
                if (!fileName.startsWith("android-")) continue;
                try {
                    Integer aux = Integer.parseInt(fileName.substring("android-".length()));
                    if (aux < version || versionNumber != null && versionNumber <= aux) continue;
                    versionNumber = aux;
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (versionNumber != null) {
                return new File(new File(jarDir, "android-" + versionNumber), "android.jar");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getClassPathFiles() throws ConfigurationException {
        LinkedHashSet<File> classPathFiles;
        block22: {
            ProjectConnection connection = this.getConnector().connect();
            classPathFiles = new LinkedHashSet<File>();
            try {
                EclipseProject project = (EclipseProject)connection.getModel(EclipseProject.class);
                File gradleBuildDir = project.getGradleProject().getBuildDirectory();
                File classesDir = new File(gradleBuildDir, this.buildDir);
                boolean isAndroid = false;
                if (classesDir.exists()) {
                    File[] files = classesDir.listFiles();
                    if (files != null) {
                        for (File file : files) {
                            classPathFiles.add(file);
                        }
                    }
                } else {
                    isAndroid = true;
                    if (this.flavor == null) {
                        classesDir = new File(gradleBuildDir, "intermediates/classes/release/");
                        if (!classesDir.exists()) {
                            throw new ConfigurationException("Please, select one flavour with the command: walkmod add-provider -Dflavor=\"YOUR_FLAVOR\" gradle");
                        }
                        classPathFiles.add(classesDir);
                    } else {
                        classesDir = new File(gradleBuildDir, "intermediates/classes/" + this.flavor + "/release/");
                        if (!classesDir.exists()) {
                            throw new ConfigurationException("The flavor :[" + this.flavor + "] does not exist in [" + classesDir.getAbsolutePath() + "]. Please, select a valid one");
                        }
                        classPathFiles.add(classesDir);
                    }
                }
                if (isAndroid) {
                    File jar;
                    List<String> coordinates = this.getDepsCoordinates(connection);
                    Integer version = this.getCompileAndroidSDKVersion(project.getGradleProject().getProjectDirectory());
                    if (version != null && (jar = this.getAndroidJar(version)) != null && jar.exists()) {
                        classPathFiles.add(jar);
                    }
                    if (!coordinates.isEmpty()) {
                        classPathFiles.addAll(this.resolveArtifacts(coordinates));
                    }
                    if (this.localLibs == null) break block22;
                    try {
                        Iterator it = this.localLibs.iterator();
                        while (it.hasNext()) {
                            File auxLibs = new File(it.next().toString()).getCanonicalFile();
                            if (!auxLibs.exists()) continue;
                            if (auxLibs.isDirectory()) {
                                File[] files;
                                for (File jar2 : files = auxLibs.listFiles()) {
                                    classPathFiles.add(jar2);
                                }
                                continue;
                            }
                            classPathFiles.add(auxLibs);
                        }
                        break block22;
                    }
                    catch (IOException e) {
                        throw new ConfigurationException("Error resolving the libs directories", (Throwable)e);
                    }
                }
                for (ExternalDependency externalDependency : project.getClasspath()) {
                    classPathFiles.add(externalDependency.getFile());
                }
                DomainObjectSet modules = project.getProjectDependencies();
                if (modules != null) {
                    for (EclipseProjectDependency current : modules) {
                        ClassLoaderConfigurationProvider prov = new ClassLoaderConfigurationProvider();
                        prov.setWorkingDirectory(current.getTargetProject().getProjectDirectory().getAbsolutePath());
                        classPathFiles.addAll(prov.getClassPathFiles());
                    }
                }
            }
            finally {
                connection.close();
            }
        }
        return new LinkedList<File>(classPathFiles);
    }

    private void unzipAAR(String zipFilePath, String destDirectory) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = destDirectory + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                if (entry.getName().endsWith(".jar")) {
                    this.extractFile(zipIn, filePath);
                }
            } else if (entry.getName().endsWith("jars/") || entry.getName().endsWith("libs/")) {
                File dir = new File(filePath);
                dir.mkdir();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }

    private void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

    public Collection<File> resolveArtifacts(List<String> coordinates) throws ConfigurationException {
        LinkedList<File> result = new LinkedList<File>();
        if (coordinates != null) {
            File aux = new File(this.userHomeDir, "caches/modules-2/files-2.1");
            for (String coordinate : coordinates) {
                String[] parts = coordinate.split(":");
                File groupIdDir = new File(aux, parts[0]);
                File artifactIdDir = new File(groupIdDir, parts[1]);
                File versionDir = new File(artifactIdDir, parts[2]);
                File[] subdirs = versionDir.listFiles();
                boolean found = false;
                if (subdirs == null) {
                    String androidHome = System.getenv("ANDROID_HOME");
                    if (androidHome == null || "".equals(androidHome)) continue;
                    File androidHomeFile = new File(androidHome);
                    File repo = null;
                    repo = parts[0].contains("google") ? new File(androidHomeFile, "extras/google/m2repository") : new File(androidHomeFile, "extras/android/m2repository");
                    groupIdDir = new File(repo, parts[0].replaceAll("\\.", File.separator));
                    artifactIdDir = new File(groupIdDir, parts[1]);
                    versionDir = new File(artifactIdDir, parts[2]);
                    File aarFile = new File(versionDir, parts[1] + "-" + parts[2] + ".aar");
                    if (aarFile.exists()) {
                        try {
                            File jarClasses = new File(versionDir, "classes.jar");
                            this.unzipAAR(aarFile.getAbsolutePath(), versionDir.getAbsolutePath());
                            result.add(jarClasses);
                            File libFolder = new File(versionDir, "libs");
                            if (!libFolder.exists()) continue;
                            for (File lib : subdirs = libFolder.listFiles()) {
                                result.add(lib);
                            }
                            continue;
                        }
                        catch (IOException e) {
                            throw new ConfigurationException("Error extracting the aar file " + aarFile.getAbsolutePath(), (Throwable)e);
                        }
                    }
                    File jarFile = new File(versionDir, parts[1] + "-" + parts[2] + ".jar");
                    if (jarFile.exists()) {
                        result.add(jarFile);
                        continue;
                    }
                    System.out.println(coordinate);
                    continue;
                }
                for (int i = 0; i < subdirs.length && !found; ++i) {
                    File parentDir = subdirs[i];
                    if (!parentDir.isDirectory()) continue;
                    File file = new File(parentDir, parts[1] + "-" + parts[2] + ".jar");
                    if (file.exists()) {
                        result.add(file);
                        found = true;
                        continue;
                    }
                    file = new File(parentDir, parts[1] + "-" + parts[2] + ".aar");
                    if (!file.exists()) continue;
                    try {
                        File jarClasses = new File(parentDir, "classes.jar");
                        if (!jarClasses.exists()) {
                            this.unzipAAR(file.getAbsolutePath(), parentDir.getAbsolutePath());
                        }
                        result.add(jarClasses);
                        File libFolder = new File(parentDir, "libs");
                        if (libFolder.exists()) {
                            File[] deps;
                            for (File lib : deps = libFolder.listFiles()) {
                                result.add(lib);
                            }
                        }
                        found = true;
                        continue;
                    }
                    catch (IOException e) {
                        throw new ConfigurationException("Error extracting aar", (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    public void load() throws ConfigurationException {
        if (this.configuration != null) {
            try {
                this.compile();
            }
            catch (Exception e1) {
                throw new ConfigurationException("Error compiling the project", e1.getCause());
            }
            List<File> classPathList = this.getClassPathFiles();
            String[] bootPath = System.getProperties().get("sun.boot.class.path").toString().split(Character.toString(File.pathSeparatorChar));
            URL[] classPath = new URL[classPathList.size() + bootPath.length];
            int i = 0;
            for (String lib : bootPath) {
                try {
                    classPath[i] = new File(lib).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new ConfigurationException("Invalid URL for the boot classpath entry " + lib, e.getCause());
                }
                ++i;
            }
            if (!classPathList.isEmpty()) {
                for (File entry : classPathList) {
                    try {
                        classPath[i] = entry.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        throw new ConfigurationException("Invalid URL for the dependency " + entry.getAbsolutePath(), e.getCause());
                    }
                    ++i;
                }
            }
            URLClassLoader loader = new URLClassLoader(classPath){

                @Override
                protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                    Class<?> result = null;
                    try {
                        result = this.findClass(name);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    if (result != null) {
                        return result;
                    }
                    return super.loadClass(name, resolve);
                }

                @Override
                public Class<?> loadClass(String name) throws ClassNotFoundException {
                    return this.loadClass(name, false);
                }
            };
            this.configuration.getParameters().put("classLoader", loader);
        }
    }
}

