/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.gradle.providers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.ExternalDependency;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.walkmod.conf.ConfigurationException;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.Configuration;

public class ClassLoaderConfigurationProvider
implements ConfigurationProvider {
    private File pomFile = null;
    private String buildDir = "classes";
    private Configuration configuration;
    private String installationDir;
    private String userHomeDir;
    private String workingDirectory;
    private GradleConnector connector = null;

    public void setInstallationDir(String installationDir) {
        this.installationDir = installationDir;
    }

    public void setUserHomeDir(String userHomeDir) {
        this.userHomeDir = userHomeDir;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setBuildDir(String buildDir) {
        this.buildDir = buildDir;
    }

    public File getPomFile() {
        return this.pomFile;
    }

    public void setPomFile(File file) {
        this.pomFile = file;
    }

    public void init(Configuration configuration) {
        this.configuration = configuration;
    }

    public GradleConnector getConnector() throws ConfigurationException {
        if (this.connector == null) {
            this.connector = GradleConnector.newConnector();
            if (this.installationDir != null) {
                this.connector.useInstallation(new File(this.installationDir));
                if (this.userHomeDir != null) {
                    this.connector.useGradleUserHomeDir(new File(this.userHomeDir));
                } else {
                    try {
                        this.userHomeDir = new File(System.getProperty("user.home"), ".gradle").getCanonicalPath();
                    }
                    catch (IOException e) {
                        throw new ConfigurationException("Error resolving the working directory", e.getCause());
                    }
                }
            } else {
                try {
                    this.userHomeDir = new File(System.getProperty("user.home"), ".gradle").getCanonicalPath();
                }
                catch (IOException e) {
                    throw new ConfigurationException("Error resolving the working directory", e.getCause());
                }
            }
            if (this.workingDirectory == null) {
                try {
                    this.workingDirectory = new File(".").getCanonicalPath();
                }
                catch (IOException e) {
                    throw new ConfigurationException("Error resolving the working directory", e.getCause());
                }
            }
            this.connector.forProjectDirectory(new File(this.workingDirectory));
        }
        return this.connector;
    }

    public void compile() throws Exception {
        ProjectConnection connection = this.getConnector().connect();
        try {
            BuildLauncher launcher = connection.newBuild();
            launcher.forTasks(new String[]{"assemble"});
            launcher.setStandardOutput((OutputStream)System.out);
            launcher.setStandardError((OutputStream)System.err);
            launcher.run();
        }
        finally {
            connection.close();
        }
    }

    private List<String> getDepsCoordinates(ProjectConnection connection) {
        BuildLauncher launcher = connection.newBuild();
        launcher.forTasks(new String[]{"dependencies"});
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        launcher.setStandardOutput((OutputStream)bos);
        launcher.setStandardError((OutputStream)System.err);
        launcher.run();
        String content = bos.toString();
        String[] lines = content.split("\\n");
        LinkedList<String> coordinates = new LinkedList<String>();
        for (int i = 0; i < lines.length; ++i) {
            if (!lines[i].startsWith("compile") && !lines[i].startsWith("provided") || i + 1 >= lines.length || lines[i + 1].startsWith("No dependencies")) continue;
            int j = i + 1;
            String prefix = null;
            String nextGoal = "debugApk";
            if (lines[i].startsWith("provided")) {
                nextGoal = "releaseApk";
            }
            while (j < lines.length && !lines[j].startsWith(nextGoal)) {
                int index = lines[j].lastIndexOf("--");
                if (index != -1) {
                    String artifact;
                    prefix = lines[j].substring(0, index + 2);
                    if (lines[j].length() > prefix.length() && !(artifact = lines[j].substring(prefix.length()).trim()).endsWith("(*)")) {
                        int dynamicVersionIndex = artifact.indexOf("->");
                        if (dynamicVersionIndex != -1) {
                            String artifactName = artifact.substring(0, artifact.lastIndexOf(":")).trim();
                            String version = artifact.substring(dynamicVersionIndex + 2).trim();
                            artifact = artifactName + ":" + version;
                        }
                        coordinates.add(artifact);
                    }
                }
                ++j;
            }
        }
        return coordinates;
    }

    private Integer getMinAndroidSDKVersion(File projectDir) {
        File cfg = new File(projectDir, "build.gradle");
        Integer version = null;
        try {
            List cfgContent = FileUtils.readLines((File)cfg);
            Iterator it = cfgContent.iterator();
            while (it.hasNext() && version == null) {
                String line = (String)it.next();
                int index = line.indexOf("minSdkVersion ");
                if (index == -1) continue;
                version = Integer.parseInt(line.substring(index + "minSdkVersion ".length()).trim());
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading the build.gradle", e.getCause());
        }
        return version;
    }

    private File getAndroidJar(Integer version) {
        File jarDir;
        String androidHome = System.getenv("ANDROID_HOME");
        if (androidHome != null && !"".equals(androidHome) && (jarDir = new File(androidHome, "platforms/")).exists()) {
            Integer versionNumber = null;
            File[] files = jarDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String fileName = files[i].getName();
                if (!fileName.startsWith("android-")) continue;
                try {
                    Integer aux = Integer.parseInt(fileName.substring("android-".length()));
                    if (aux <= version || versionNumber != null && versionNumber <= aux) continue;
                    versionNumber = aux;
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (versionNumber != null) {
                return new File(new File(jarDir, "android-" + versionNumber), "android.jar");
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getClassPathFiles() throws ConfigurationException {
        ProjectConnection connection = this.getConnector().connect();
        LinkedList<File> classPathFiles = new LinkedList<File>();
        try {
            EclipseProject project = (EclipseProject)connection.getModel(EclipseProject.class);
            File gradleBuildDir = project.getGradleProject().getBuildDirectory();
            File classesDir = new File(gradleBuildDir, this.buildDir);
            boolean isAndroid = false;
            if (classesDir.exists()) {
                File[] files = classesDir.listFiles();
                if (files != null) {
                    for (File file : files) {
                        classPathFiles.add(file);
                    }
                }
            } else {
                isAndroid = true;
                classesDir = new File(gradleBuildDir, "intermediates/classes/release/");
                classPathFiles.add(classesDir);
            }
            if (isAndroid) {
                File jar;
                List<String> coordinates = this.getDepsCoordinates(connection);
                Integer version = this.getMinAndroidSDKVersion(project.getGradleProject().getProjectDirectory());
                if (version != null && (jar = this.getAndroidJar(version)) != null && jar.exists()) {
                    classPathFiles.add(jar);
                }
                if (!coordinates.isEmpty()) {
                    classPathFiles.addAll(this.resolveArtifacts(coordinates));
                }
            } else {
                for (ExternalDependency externalDependency : project.getClasspath()) {
                    classPathFiles.add(externalDependency.getFile());
                }
            }
        }
        finally {
            connection.close();
        }
        return classPathFiles;
    }

    public Collection<File> resolveArtifacts(List<String> coordinates) throws ConfigurationException {
        LinkedList<File> result = new LinkedList<File>();
        if (coordinates != null) {
            File aux = new File(this.userHomeDir, "caches/modules-2/files-2.1");
            for (String coordinate : coordinates) {
                String[] parts = coordinate.split(":");
                File groupIdDir = new File(aux, parts[0]);
                File artifactIdDir = new File(groupIdDir, parts[1]);
                File versionDir = new File(artifactIdDir, parts[2]);
                File[] subdirs = versionDir.listFiles();
                boolean found = false;
                for (int i = 0; i < subdirs.length && !found; ++i) {
                    File file;
                    File parentDir = subdirs[i];
                    if (!parentDir.isDirectory() || !(file = new File(parentDir, parts[1] + "-" + parts[2] + ".jar")).exists()) continue;
                    result.add(file);
                    found = true;
                }
            }
        }
        return result;
    }

    public void load() throws ConfigurationException {
        if (this.configuration != null) {
            try {
                this.compile();
            }
            catch (Exception e1) {
                throw new ConfigurationException("Error compiling the project", e1.getCause());
            }
            List<File> classPathList = this.getClassPathFiles();
            String[] bootPath = System.getProperties().get("sun.boot.class.path").toString().split(Character.toString(File.pathSeparatorChar));
            URL[] classPath = new URL[classPathList.size() + bootPath.length];
            int i = 0;
            for (String lib : bootPath) {
                try {
                    classPath[i] = new File(lib).toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new ConfigurationException("Invalid URL for the boot classpath entry " + lib, e.getCause());
                }
                ++i;
            }
            if (!classPathList.isEmpty()) {
                for (File entry : classPathList) {
                    try {
                        classPath[i] = entry.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        throw new ConfigurationException("Invalid URL for the dependency " + entry.getAbsolutePath(), e.getCause());
                    }
                    ++i;
                }
            }
            URLClassLoader loader = new URLClassLoader(classPath){

                @Override
                protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                    Class<?> result = null;
                    try {
                        result = this.findClass(name);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    if (result != null) {
                        return result;
                    }
                    return super.loadClass(name, resolve);
                }

                @Override
                public Class<?> loadClass(String name) throws ClassNotFoundException {
                    return this.loadClass(name, false);
                }
            };
            this.configuration.getParameters().put("classLoader", loader);
        }
    }
}

