/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.gradle.providers;

import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import java.util.List;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.ExternalDependency;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.walkmod.conf.ConfigurationException;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.Configuration;

public class ClassLoaderConfigurationProvider
implements ConfigurationProvider {
    private File pomFile = null;
    private String buildDir = "classes";
    private Configuration configuration;
    private String installationDir;
    private String userHomeDir;
    private String workingDirectory;
    private GradleConnector connector = null;

    public void setInstallationDir(String installationDir) {
        this.installationDir = installationDir;
    }

    public void setUserHomeDir(String userHomeDir) {
        this.userHomeDir = userHomeDir;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public void setBuildDir(String buildDir) {
        this.buildDir = buildDir;
    }

    public File getPomFile() {
        return this.pomFile;
    }

    public void setPomFile(File file) {
        this.pomFile = file;
    }

    public void init(Configuration configuration) {
        this.configuration = configuration;
    }

    public GradleConnector getConnector() {
        if (this.connector == null) {
            this.connector = GradleConnector.newConnector();
            if (this.installationDir != null) {
                this.connector.useInstallation(new File(this.installationDir));
                if (this.userHomeDir != null) {
                    this.connector.useGradleUserHomeDir(new File(this.userHomeDir));
                }
            }
            this.connector.forProjectDirectory(new File(this.workingDirectory));
        }
        return this.connector;
    }

    public void compile() throws Exception {
        ProjectConnection connection = this.getConnector().connect();
        try {
            BuildLauncher launcher = connection.newBuild();
            launcher.forTasks(new String[]{"compileJava", "compileTestJava"});
            launcher.setStandardOutput((OutputStream)System.out);
            launcher.setStandardError((OutputStream)System.err);
            launcher.run();
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<File> getClassPathFiles() {
        ProjectConnection connection = this.getConnector().connect();
        LinkedList<File> classPathFiles = new LinkedList<File>();
        try {
            EclipseProject project = (EclipseProject)connection.getModel(EclipseProject.class);
            File gradleBuildDir = project.getGradleProject().getBuildDirectory();
            File classesDir = new File(gradleBuildDir, this.buildDir);
            File[] files = classesDir.listFiles();
            if (files != null) {
                for (File file : files) {
                    classPathFiles.add(file);
                }
            }
            for (ExternalDependency externalDependency : project.getClasspath()) {
                classPathFiles.add(externalDependency.getFile());
            }
        }
        finally {
            connection.close();
        }
        return classPathFiles;
    }

    public void load() throws ConfigurationException {
        if (this.configuration != null) {
            try {
                this.compile();
            }
            catch (Exception e1) {
                throw new ConfigurationException(e1.getMessage());
            }
            List<File> classPathList = this.getClassPathFiles();
            if (!classPathList.isEmpty()) {
                URL[] classPath = new URL[classPathList.size()];
                int i = 0;
                for (File entry : classPathList) {
                    try {
                        classPath[i] = entry.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        throw new ConfigurationException("Invalid URL for the dependency " + entry.getAbsolutePath(), e.getCause());
                    }
                    ++i;
                }
                URLClassLoader loader = new URLClassLoader(classPath);
                this.configuration.getParameters().put("classLoader", loader);
            }
        }
    }
}

