/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.deadcodecleaner.visitors;

import java.io.Externalizable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.walkmod.deadcodecleaner.visitors.CleanDeadDeclarationsVisitor;
import org.walkmod.javalang.ast.FieldSymbolData;
import org.walkmod.javalang.ast.ImportDeclaration;
import org.walkmod.javalang.ast.MethodSymbolData;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.SymbolData;
import org.walkmod.javalang.ast.SymbolDataAware;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.body.AnnotationDeclaration;
import org.walkmod.javalang.ast.body.BodyDeclaration;
import org.walkmod.javalang.ast.body.ClassOrInterfaceDeclaration;
import org.walkmod.javalang.ast.body.EmptyTypeDeclaration;
import org.walkmod.javalang.ast.body.EnumDeclaration;
import org.walkmod.javalang.ast.body.FieldDeclaration;
import org.walkmod.javalang.ast.body.MethodDeclaration;
import org.walkmod.javalang.ast.body.ModifierSet;
import org.walkmod.javalang.ast.body.Parameter;
import org.walkmod.javalang.ast.body.TypeDeclaration;
import org.walkmod.javalang.ast.body.VariableDeclarator;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.expr.ArrayInitializerExpr;
import org.walkmod.javalang.ast.expr.ClassExpr;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.expr.MarkerAnnotationExpr;
import org.walkmod.javalang.ast.expr.MemberValuePair;
import org.walkmod.javalang.ast.expr.MethodCallExpr;
import org.walkmod.javalang.ast.expr.NormalAnnotationExpr;
import org.walkmod.javalang.ast.expr.ObjectCreationExpr;
import org.walkmod.javalang.ast.expr.SingleMemberAnnotationExpr;
import org.walkmod.javalang.ast.expr.StringLiteralExpr;
import org.walkmod.javalang.ast.expr.VariableDeclarationExpr;
import org.walkmod.javalang.ast.stmt.ForStmt;
import org.walkmod.javalang.ast.stmt.ForeachStmt;
import org.walkmod.javalang.ast.stmt.TryStmt;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.GenericVisitorAdapter;
import org.walkmod.javalang.visitors.VoidVisitor;
import org.walkmod.javalang.visitors.VoidVisitorAdapter;

public class UnusedDefinitionsRemover
extends GenericVisitorAdapter<Boolean, Iterator<? extends Node>> {
    private CleanDeadDeclarationsVisitor<?> siblingsVisitor;

    public UnusedDefinitionsRemover(CleanDeadDeclarationsVisitor<?> siblingsVisitor) {
        this.siblingsVisitor = siblingsVisitor;
    }

    public Boolean visitTypeDeclaration(TypeDeclaration n, Iterator<? extends Node> it) {
        boolean removed = false;
        if (ModifierSet.isPrivate((int)n.getModifiers())) {
            List usages = n.getUsages();
            if (usages == null || usages.isEmpty()) {
                HasSupressWarning warning = new HasSupressWarning();
                Boolean containsSupressWarnings = (Boolean)n.accept((GenericVisitor)warning, null);
                if (containsSupressWarnings == null) {
                    containsSupressWarnings = false;
                }
                if (!containsSupressWarnings.booleanValue()) {
                    it.remove();
                    removed = true;
                    this.removeOrphanBodyReferences((SymbolDefinition)n);
                }
            } else {
                n.accept(this.siblingsVisitor, null);
            }
        } else {
            n.accept(this.siblingsVisitor, null);
        }
        return removed;
    }

    public Boolean visit(ClassOrInterfaceDeclaration n, Iterator<? extends Node> it) {
        if (this.siblingsVisitor.getRemoveUnusedClasses().booleanValue() && !n.isInterface() || this.siblingsVisitor.getRemoveUnusedInterfaces().booleanValue() && n.isInterface()) {
            return this.visitTypeDeclaration((TypeDeclaration)n, it);
        }
        n.accept(this.siblingsVisitor, null);
        return false;
    }

    public Boolean visit(EnumDeclaration n, Iterator<? extends Node> it) {
        if (this.siblingsVisitor.getRemoveUnusedEnumerations().booleanValue()) {
            return this.visitTypeDeclaration((TypeDeclaration)n, it);
        }
        n.accept(this.siblingsVisitor, null);
        return false;
    }

    public Boolean visit(AnnotationDeclaration n, Iterator<? extends Node> it) {
        if (this.siblingsVisitor.getRemoveUnusedAnnotationTypes().booleanValue()) {
            return this.visitTypeDeclaration((TypeDeclaration)n, it);
        }
        n.accept(this.siblingsVisitor, null);
        return false;
    }

    public Boolean visit(EmptyTypeDeclaration n, Iterator<? extends Node> it) {
        return false;
    }

    public Boolean visit(MethodDeclaration n, Iterator<? extends Node> it) {
        boolean removed = false;
        if (this.siblingsVisitor.getRemoveUnusedMethods().booleanValue() && ModifierSet.isPrivate((int)n.getModifiers())) {
            List usages = n.getUsages();
            if (usages == null || usages.isEmpty()) {
                MethodSymbolData msd;
                boolean canBeRemoved;
                List params;
                String name;
                boolean belongsToSerializableOrExternalizable = this.belongsToClass((BodyDeclaration)n, Serializable.class);
                boolean containsAnSerializableMethod = false;
                HasSupressWarning warning = new HasSupressWarning();
                Boolean containsSupressWarnings = (Boolean)n.accept((GenericVisitor)warning, null);
                if (containsSupressWarnings == null) {
                    containsSupressWarnings = false;
                }
                if (belongsToSerializableOrExternalizable || this.siblingsVisitor.getIgnoreSerializableMethods().booleanValue()) {
                    SymbolData sd;
                    name = n.getName();
                    params = n.getParameters();
                    if ((name.equals("readResolve") || name.equals("readObjectNoData") || name.equals("writeReplace")) && (params == null || params.isEmpty())) {
                        containsAnSerializableMethod = true;
                    } else if (name.equals("readObject") && params != null && params.size() == 1) {
                        SymbolData sd2 = ((Parameter)params.get(0)).getSymbolData();
                        if (sd2 != null) {
                            containsAnSerializableMethod = sd2.getClazz().equals(ObjectInputStream.class);
                        }
                    } else if (name.equals("writeObject") && params != null && params.size() == 1 && (sd = ((Parameter)params.get(0)).getSymbolData()) != null) {
                        containsAnSerializableMethod = sd.getClazz().equals(ObjectOutputStream.class);
                    }
                } else {
                    belongsToSerializableOrExternalizable = this.belongsToClass((BodyDeclaration)n, Externalizable.class);
                    name = n.getName();
                    params = n.getParameters();
                    if ((name.equals("readResolve") || name.equals("writeReplace")) && (params == null || params.isEmpty())) {
                        containsAnSerializableMethod = true;
                    }
                }
                boolean bl = canBeRemoved = !belongsToSerializableOrExternalizable && this.siblingsVisitor.getIgnoreSerializableMethods() == false || !containsAnSerializableMethod;
                if (!(!canBeRemoved || containsSupressWarnings.booleanValue() || (msd = n.getSymbolData()) != null && this.siblingsVisitor.isExcluded(msd.getMethod()))) {
                    it.remove();
                    removed = true;
                    this.removeOrphanBodyReferences((SymbolDefinition)n);
                }
            } else {
                n.accept(this.siblingsVisitor, null);
            }
        } else {
            n.accept(this.siblingsVisitor, null);
        }
        return removed;
    }

    private boolean belongsToClass(BodyDeclaration n, Class<?> clazz) {
        SymbolData sd;
        boolean belongsToSerializable = false;
        Node grandparent = n.getParentNode();
        if (grandparent instanceof SymbolDataAware && (sd = ((SymbolDataAware)grandparent).getSymbolData()) != null) {
            belongsToSerializable = clazz.isAssignableFrom(sd.getClazz());
        }
        return belongsToSerializable;
    }

    public Boolean visit(FieldDeclaration n, Iterator<? extends Node> it) {
        boolean removed = false;
        if (this.siblingsVisitor.getRemoveUnusedFields().booleanValue() && ModifierSet.isPrivate((int)n.getModifiers())) {
            List usages = n.getUsages();
            if (usages == null || usages.isEmpty()) {
                boolean canBeRemoved;
                List vds;
                boolean belongsToSerializable = this.belongsToClass((BodyDeclaration)n, Serializable.class);
                boolean hasSerialVersionUID = false;
                boolean hasRemovableVars = true;
                HasSupressWarning warning = new HasSupressWarning();
                Boolean containsSupressWarnings = (Boolean)n.accept((GenericVisitor)warning, null);
                if (containsSupressWarnings == null) {
                    containsSupressWarnings = false;
                }
                if ((vds = n.getVariables()) != null) {
                    Iterator itV = vds.iterator();
                    while (itV.hasNext() && !hasSerialVersionUID && hasRemovableVars) {
                        VariableDeclarator vd = (VariableDeclarator)itV.next();
                        hasSerialVersionUID = vd.getId().getName().equals("serialVersionUID");
                        if (hasSerialVersionUID) continue;
                        HashSet ctx = new HashSet();
                        VoidVisitorAdapter<Set<Node>> v = new VoidVisitorAdapter<Set<Node>>(){

                            public void visit(MethodCallExpr n, Set<Node> ctx) {
                                ctx.add((Node)n);
                            }

                            public void visit(ObjectCreationExpr n, Set<Node> ctx) {
                                ctx.add((Node)n);
                            }

                            public void visit(ClassExpr n, Set<Node> ctx) {
                                ctx.add((Node)n);
                            }
                        };
                        Expression expr = vd.getInit();
                        if (expr != null) {
                            expr.accept((VoidVisitor)v, ctx);
                        }
                        hasRemovableVars = ctx.isEmpty();
                    }
                }
                boolean bl = canBeRemoved = (!belongsToSerializable || !hasSerialVersionUID) && hasRemovableVars;
                if (canBeRemoved && !containsSupressWarnings.booleanValue()) {
                    boolean remove = true;
                    List listfsd = n.getFieldsSymbolData();
                    if (listfsd != null) {
                        Iterator itfsd = listfsd.iterator();
                        while (itfsd.hasNext() && remove) {
                            FieldSymbolData fsd = (FieldSymbolData)itfsd.next();
                            remove = !this.siblingsVisitor.isExcluded(fsd.getField());
                        }
                    }
                    if (remove) {
                        it.remove();
                        this.removeOrphanBodyReferences((SymbolDefinition)n);
                        removed = true;
                        Type sr = n.getType();
                        if (sr != null) {
                            sr.accept(this.siblingsVisitor.getTypeUpdater(), null);
                        }
                    }
                } else {
                    n.accept(this.siblingsVisitor, null);
                }
            } else {
                n.accept(this.siblingsVisitor, null);
            }
        } else {
            n.accept(this.siblingsVisitor, null);
        }
        return removed;
    }

    public Boolean visit(ImportDeclaration n, Iterator<? extends Node> it) {
        boolean removed = false;
        List usages = n.getUsages();
        if (this.siblingsVisitor.getRemoveUnusedImports().booleanValue() && usages == null || usages.isEmpty()) {
            it.remove();
            removed = true;
        } else {
            n.accept(this.siblingsVisitor, null);
        }
        return removed;
    }

    public Boolean visit(VariableDeclarator n, Iterator<? extends Node> it) {
        boolean removed = false;
        List usages = n.getUsages();
        if (this.siblingsVisitor.getRemoveUnusedVariables().booleanValue() && usages == null || usages.isEmpty()) {
            boolean canBeRemoved;
            HasSupressWarning warning;
            Node parent = n.getParentNode();
            boolean belongsToSerializable = false;
            Boolean containsSupressWarnings = false;
            if (parent instanceof FieldDeclaration) {
                belongsToSerializable = this.belongsToClass((BodyDeclaration)((FieldDeclaration)parent), Serializable.class);
            }
            if ((containsSupressWarnings = (Boolean)n.accept((GenericVisitor)(warning = new HasSupressWarning()), null)) == null) {
                containsSupressWarnings = false;
            }
            boolean bl = canBeRemoved = !belongsToSerializable || !n.getId().getName().equals("serialVersionUID");
            if (parent != null && canBeRemoved) {
                Node grandParent = parent.getParentNode();
                if (grandParent instanceof ForeachStmt) {
                    ForeachStmt foreach = (ForeachStmt)grandParent;
                    canBeRemoved = foreach.getVariable() != parent;
                } else if (grandParent instanceof ForStmt) {
                    ForStmt forStmt = (ForStmt)grandParent;
                    List initExprs = forStmt.getInit();
                    if (initExprs != null) {
                        for (Expression init : initExprs) {
                            canBeRemoved = canBeRemoved && init != parent;
                        }
                    }
                } else if (grandParent instanceof TryStmt) {
                    TryStmt tryStmt = (TryStmt)grandParent;
                    List vars = tryStmt.getResources();
                    boolean bl2 = canBeRemoved = !vars.contains(parent);
                }
            }
            if (canBeRemoved && n.getInit() != null) {
                HashSet ctx = new HashSet();
                VoidVisitorAdapter<Set<Node>> v = new VoidVisitorAdapter<Set<Node>>(){

                    public void visit(MethodCallExpr n, Set<Node> ctx) {
                        ctx.add((Node)n);
                    }

                    public void visit(ObjectCreationExpr n, Set<Node> ctx) {
                        ctx.add((Node)n);
                    }

                    public void visit(ClassExpr n, Set<Node> ctx) {
                        ctx.add((Node)n);
                    }
                };
                n.getInit().accept((VoidVisitor)v, ctx);
                canBeRemoved = ctx.isEmpty();
            }
            if (canBeRemoved && !containsSupressWarnings.booleanValue()) {
                it.remove();
                removed = true;
                this.removeOrphanBodyReferences((SymbolDefinition)n);
            }
        } else {
            n.accept(this.siblingsVisitor, null);
        }
        return removed;
    }

    public void removeOrphanBodyReferences(SymbolDefinition n) {
        List references = n.getBodyReferences();
        if (references != null) {
            Iterator refsIt = references.iterator();
            while (refsIt.hasNext()) {
                SymbolReference sr = (SymbolReference)refsIt.next();
                if (!((Node)n).contains((Node)sr)) continue;
                refsIt.remove();
                SymbolDefinition def = sr.getSymbolDefinition();
                def.getUsages().remove(sr);
                ((Node)def).getParentNode().accept(this.siblingsVisitor, null);
                refsIt = references.iterator();
            }
        }
    }

    class HasSupressWarning
    extends GenericVisitorAdapter<Boolean, Object> {
        public Boolean visit(SingleMemberAnnotationExpr n, Object ctx) {
            SymbolData sd = n.getSymbolData();
            if (sd != null && SuppressWarnings.class.isAssignableFrom(sd.getClazz())) {
                Boolean hasTheUnUnusedValue = (Boolean)n.getMemberValue().accept((GenericVisitor)this, ctx);
                if (hasTheUnUnusedValue != null) {
                    return hasTheUnUnusedValue;
                }
                return false;
            }
            return false;
        }

        public Boolean visit(NormalAnnotationExpr n, Object ctx) {
            SymbolData sd = n.getSymbolData();
            if (sd != null && SuppressWarnings.class.isAssignableFrom(sd.getClazz())) {
                Boolean hasTheUnUnusedValue = false;
                List list = n.getPairs();
                if (list != null) {
                    Iterator it = list.iterator();
                    while (it.hasNext() && !hasTheUnUnusedValue.booleanValue()) {
                        MemberValuePair m = (MemberValuePair)it.next();
                        Boolean aux = (Boolean)m.accept((GenericVisitor)this, ctx);
                        if (aux == null) continue;
                        hasTheUnUnusedValue = aux;
                    }
                }
                return hasTheUnUnusedValue;
            }
            return false;
        }

        public Boolean visit(MarkerAnnotationExpr n, Object ctx) {
            return false;
        }

        public Boolean visit(StringLiteralExpr n, Object ctx) {
            return n.getValue().equals("unused");
        }

        public Boolean visit(ArrayInitializerExpr n, Object arg) {
            Boolean containsSupressWarnings = false;
            if (n.getValues() != null) {
                Iterator it = n.getValues().iterator();
                while (it.hasNext() && !containsSupressWarnings.booleanValue()) {
                    Boolean aux = (Boolean)((Expression)it.next()).accept((GenericVisitor)this, arg);
                    if (aux == null) continue;
                    containsSupressWarnings = aux;
                }
            }
            return containsSupressWarnings;
        }

        public Boolean visit(VariableDeclarator n, Object ctx) {
            return (Boolean)n.getParentNode().accept((GenericVisitor)this, ctx);
        }

        public Boolean visit(VariableDeclarationExpr n, Object ctx) {
            Boolean containsSupressWarnings = false;
            List ann = n.getAnnotations();
            if (ann != null) {
                Iterator itAnnotations = ann.iterator();
                while (itAnnotations.hasNext() && !containsSupressWarnings.booleanValue()) {
                    Boolean aux;
                    AnnotationExpr annotation = (AnnotationExpr)itAnnotations.next();
                    if (annotation == null || (aux = (Boolean)annotation.accept((GenericVisitor)this, null)) == null) continue;
                    containsSupressWarnings = aux;
                }
            }
            return containsSupressWarnings;
        }

        public Boolean visit(FieldDeclaration n, Object ctx) {
            boolean containsSupressWarnings = false;
            List ann = n.getAnnotations();
            if (ann != null) {
                Iterator itAnnotations = ann.iterator();
                while (itAnnotations.hasNext() && !containsSupressWarnings) {
                    AnnotationExpr annotation = (AnnotationExpr)itAnnotations.next();
                    containsSupressWarnings = (Boolean)annotation.accept((GenericVisitor)this, null);
                }
            }
            return containsSupressWarnings;
        }

        public Boolean visit(MethodDeclaration n, Object ctx) {
            boolean containsSupressWarnings = false;
            List ann = n.getAnnotations();
            if (ann != null) {
                Iterator itAnnotations = ann.iterator();
                while (itAnnotations.hasNext() && !containsSupressWarnings) {
                    AnnotationExpr annotation = (AnnotationExpr)itAnnotations.next();
                    containsSupressWarnings = (Boolean)annotation.accept((GenericVisitor)this, null);
                }
            }
            return containsSupressWarnings;
        }

        public Boolean visit(ClassOrInterfaceDeclaration n, Object ctx) {
            boolean containsSupressWarnings = false;
            List ann = n.getAnnotations();
            if (ann != null) {
                Iterator itAnnotations = ann.iterator();
                while (itAnnotations.hasNext() && !containsSupressWarnings) {
                    AnnotationExpr annotation = (AnnotationExpr)itAnnotations.next();
                    containsSupressWarnings = (Boolean)annotation.accept((GenericVisitor)this, null);
                }
            }
            return containsSupressWarnings;
        }

        public Boolean visit(EnumDeclaration n, Object ctx) {
            boolean containsSupressWarnings = false;
            List ann = n.getAnnotations();
            if (ann != null) {
                Iterator itAnnotations = ann.iterator();
                while (itAnnotations.hasNext() && !containsSupressWarnings) {
                    AnnotationExpr annotation = (AnnotationExpr)itAnnotations.next();
                    containsSupressWarnings = (Boolean)annotation.accept((GenericVisitor)this, null);
                }
            }
            return containsSupressWarnings;
        }

        public Boolean visit(AnnotationDeclaration n, Object ctx) {
            boolean containsSupressWarnings = false;
            List ann = n.getAnnotations();
            if (ann != null) {
                Iterator itAnnotations = ann.iterator();
                while (itAnnotations.hasNext() && !containsSupressWarnings) {
                    AnnotationExpr annotation = (AnnotationExpr)itAnnotations.next();
                    containsSupressWarnings = (Boolean)annotation.accept((GenericVisitor)this, null);
                }
            }
            return containsSupressWarnings;
        }

        public Boolean visit(EmptyTypeDeclaration n, Object ctx) {
            boolean containsSupressWarnings = false;
            List ann = n.getAnnotations();
            if (ann != null) {
                Iterator itAnnotations = ann.iterator();
                while (itAnnotations.hasNext() && !containsSupressWarnings) {
                    AnnotationExpr annotation = (AnnotationExpr)itAnnotations.next();
                    containsSupressWarnings = (Boolean)annotation.accept((GenericVisitor)this, null);
                }
            }
            return containsSupressWarnings;
        }
    }
}

