/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.deadcodecleaner.visitors;

import com.alibaba.fastjson.JSONArray;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.walkmod.deadcodecleaner.visitors.UnusedDefinitionsRemover;
import org.walkmod.javalang.ast.CompilationUnit;
import org.walkmod.javalang.ast.ImportDeclaration;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.body.AnnotationDeclaration;
import org.walkmod.javalang.ast.body.BodyDeclaration;
import org.walkmod.javalang.ast.body.ClassOrInterfaceDeclaration;
import org.walkmod.javalang.ast.body.EnumConstantDeclaration;
import org.walkmod.javalang.ast.body.EnumDeclaration;
import org.walkmod.javalang.ast.body.FieldDeclaration;
import org.walkmod.javalang.ast.body.ModifierSet;
import org.walkmod.javalang.ast.body.TypeDeclaration;
import org.walkmod.javalang.ast.body.VariableDeclarator;
import org.walkmod.javalang.ast.expr.ObjectCreationExpr;
import org.walkmod.javalang.ast.expr.VariableDeclarationExpr;
import org.walkmod.javalang.ast.stmt.BlockStmt;
import org.walkmod.javalang.ast.stmt.TypeDeclarationStmt;
import org.walkmod.javalang.ast.type.ClassOrInterfaceType;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.compiler.symbols.RequiresSemanticAnalysis;
import org.walkmod.javalang.javadoclinks.JavadocLinkParser;
import org.walkmod.javalang.javadoclinks.MethodLink;
import org.walkmod.javalang.javadoclinks.ParseException;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;
import org.walkmod.javalang.visitors.VoidVisitorAdapter;

@RequiresSemanticAnalysis
public class CleanDeadDeclarationsVisitor<T>
extends VoidVisitorAdapter<T> {
    private Boolean removeUnusedImports = true;
    private Boolean removeUnusedVariables = true;
    private Boolean removeUnusedClasses = true;
    private Boolean removeUnusedInterfaces = true;
    private Boolean removeUnusedAnnotationTypes = true;
    private Boolean removeUnusedEnumerations = true;
    private Boolean removeUnusedMethods = true;
    private Boolean removeUnusedFields = true;
    private Boolean ignoreSerializableMethods = false;
    private Map<String, List<MethodLink>> excludedMethods = new HashMap<String, List<MethodLink>>();
    private UnusedDefinitionsRemover remover = new UnusedDefinitionsRemover(this);
    private TypeUpdater<T> typeUpdater = new TypeUpdater(this);

    public void visit(CompilationUnit n, T arg) {
        List types;
        List imports = n.getImports();
        if (imports != null && this.removeUnusedImports.booleanValue()) {
            Iterator it = imports.iterator();
            while (it.hasNext()) {
                ImportDeclaration id = (ImportDeclaration)it.next();
                id.accept((GenericVisitor)this.remover, it);
            }
        }
        if ((types = n.getTypes()) != null) {
            Iterator it = types.iterator();
            while (it.hasNext()) {
                TypeDeclaration td = (TypeDeclaration)it.next();
                if (this.removeUnusedClasses.booleanValue()) {
                    td.accept((GenericVisitor)this.remover, it);
                    continue;
                }
                td.accept((VoidVisitor)this, arg);
            }
        }
    }

    public boolean isExcluded(Method method) {
        List<MethodLink> candidates;
        if (method != null && (candidates = this.excludedMethods.get(method.getName())) != null) {
            Iterator<MethodLink> it = candidates.iterator();
            boolean selected = false;
            if (it.hasNext() && !selected) {
                Class<?> clazz;
                MethodLink next = it.next();
                String className = next.getClassName();
                for (clazz = method.getDeclaringClass(); clazz != null && clazz.isAnonymousClass(); clazz = clazz.getSuperclass()) {
                }
                boolean bl = selected = !"".equals(className) && clazz != null && clazz.getName().equals(className);
                if (selected) {
                    List args;
                    Class<?>[] params = method.getParameterTypes();
                    if (params.length == (args = next.getArguments()).size()) {
                        Iterator itArgs = args.iterator();
                        int i = 0;
                        while (itArgs.hasNext() && selected) {
                            String arg = (String)itArgs.next();
                            selected = params[i].getName().equals(arg);
                            ++i;
                        }
                    } else {
                        selected = false;
                    }
                }
                return selected;
            }
        }
        return false;
    }

    public void setExcludedMethods(JSONArray jsonArray) {
        Iterator it = jsonArray.iterator();
        while (it.hasNext()) {
            String methodRef = it.next().toString();
            try {
                MethodLink ml = JavadocLinkParser.parse((String)methodRef);
                List<MethodLink> methods = this.excludedMethods.get(ml.getName());
                if (methods == null) {
                    methods = new LinkedList<MethodLink>();
                }
                methods.add(ml);
                this.excludedMethods.put(ml.getName(), methods);
            }
            catch (ParseException e) {
                throw new RuntimeException("Error parsing " + methodRef, e);
            }
        }
    }

    public void visit(AnnotationDeclaration n, T arg) {
        this.analyzeTypeDeclaration((TypeDeclaration)n, arg);
    }

    public void visit(EnumDeclaration n, T arg) {
        this.analyzeTypeDeclaration((TypeDeclaration)n, arg);
    }

    public void visit(TypeDeclarationStmt n, T arg) {
        Node stmt;
        TypeDeclaration td = n.getTypeDeclaration();
        td.accept((VoidVisitor)this, arg);
        List usages = td.getUsages();
        if ((usages == null || usages.isEmpty()) && (stmt = n.getParentNode()) instanceof BlockStmt) {
            BlockStmt block = (BlockStmt)stmt;
            LinkedList list = new LinkedList(block.getStmts());
            Iterator it2 = list.iterator();
            while (it2.hasNext()) {
                if (it2.next() != n) continue;
                it2.remove();
            }
            block.setStmts(list);
        }
    }

    public void analyzeTypeDeclaration(TypeDeclaration n, T arg) {
        List members = n.getMembers();
        if (members != null) {
            Iterator it = members.iterator();
            while (it.hasNext()) {
                BodyDeclaration current = (BodyDeclaration)it.next();
                int size = members.size();
                if (current instanceof SymbolDefinition) {
                    current.accept((GenericVisitor)this.remover, it);
                } else {
                    current.accept((VoidVisitor)this, arg);
                }
                if (members.size() == size) continue;
                it = members.iterator();
            }
        }
    }

    public void visit(ClassOrInterfaceDeclaration n, T arg) {
        this.analyzeTypeDeclaration((TypeDeclaration)n, arg);
    }

    public void visit(FieldDeclaration n, T arg) {
        boolean isPrivate = ModifierSet.isPrivate((int)n.getModifiers());
        List vars = n.getVariables();
        if (vars != null) {
            Iterator it = vars.iterator();
            while (it.hasNext()) {
                VariableDeclarator current = (VariableDeclarator)it.next();
                if (isPrivate && this.removeUnusedFields.booleanValue()) {
                    current.accept((GenericVisitor)this.remover, it);
                    continue;
                }
                current.accept((VoidVisitor)this, arg);
            }
            if (vars.isEmpty()) {
                Type sr;
                Node parent = n.getParentNode();
                List list = null;
                if (parent instanceof TypeDeclaration) {
                    list = ((TypeDeclaration)parent).getMembers();
                } else if (parent instanceof ObjectCreationExpr) {
                    list = ((ObjectCreationExpr)parent).getAnonymousClassBody();
                } else if (parent instanceof EnumConstantDeclaration) {
                    list = ((EnumConstantDeclaration)parent).getClassBody();
                }
                Iterator itB = list.iterator();
                boolean removed = false;
                while (itB.hasNext()) {
                    if (itB.next() != n) continue;
                    itB.remove();
                    removed = true;
                }
                if (removed && (sr = n.getType()) != null) {
                    sr.accept(this.typeUpdater, arg);
                }
                parent.accept((VoidVisitor)this, arg);
            }
        }
    }

    public void visit(VariableDeclarationExpr n, T arg) {
        List vars;
        if (this.removeUnusedVariables.booleanValue() && (vars = n.getVars()) != null) {
            Node stmt;
            Node parentNode;
            Iterator it = vars.iterator();
            while (it.hasNext()) {
                VariableDeclarator current = (VariableDeclarator)it.next();
                current.accept((GenericVisitor)this.remover, it);
            }
            if (vars.isEmpty() && (parentNode = n.getParentNode()) != null && (stmt = parentNode.getParentNode()) instanceof BlockStmt) {
                Type sr;
                BlockStmt block = (BlockStmt)stmt;
                LinkedList list = new LinkedList(block.getStmts());
                Iterator it2 = list.iterator();
                boolean removed = false;
                while (it2.hasNext()) {
                    if (it2.next() != parentNode) continue;
                    it2.remove();
                    removed = true;
                }
                block.setStmts(list);
                if (removed && (sr = n.getType()) != null) {
                    sr.accept(this.typeUpdater, arg);
                }
            }
        }
    }

    public TypeUpdater<T> getTypeUpdater() {
        return this.typeUpdater;
    }

    public Boolean getRemoveUnusedImports() {
        return this.removeUnusedImports;
    }

    public void setRemoveUnusedImports(Boolean removeUnusedImports) {
        this.removeUnusedImports = removeUnusedImports;
    }

    public Boolean getRemoveUnusedVariables() {
        return this.removeUnusedVariables;
    }

    public void setRemoveUnusedVariables(Boolean removeUnusedVariables) {
        this.removeUnusedVariables = removeUnusedVariables;
    }

    public Boolean getRemoveUnusedTypes() {
        return this.removeUnusedClasses;
    }

    public void setRemoveUnusedTypes(Boolean removeUnusedTypes) {
        this.removeUnusedClasses = removeUnusedTypes;
    }

    public Boolean getRemoveUnusedClasses() {
        return this.removeUnusedClasses;
    }

    public void setRemoveUnusedClasses(Boolean removeUnusedClasses) {
        this.removeUnusedClasses = removeUnusedClasses;
    }

    public Boolean getRemoveUnusedInterfaces() {
        return this.removeUnusedInterfaces;
    }

    public void setRemoveUnusedInterfaces(Boolean removeUnusedInterfaces) {
        this.removeUnusedInterfaces = removeUnusedInterfaces;
    }

    public Boolean getRemoveUnusedAnnotationTypes() {
        return this.removeUnusedAnnotationTypes;
    }

    public void setRemoveUnusedAnnotationTypes(Boolean removeUnusedAnnotationTypes) {
        this.removeUnusedAnnotationTypes = removeUnusedAnnotationTypes;
    }

    public Boolean getRemoveUnusedMethods() {
        return this.removeUnusedMethods;
    }

    public void setRemoveUnusedMethods(Boolean removeUnusedMethods) {
        this.removeUnusedMethods = removeUnusedMethods;
    }

    public Boolean getRemoveUnusedFields() {
        return this.removeUnusedFields;
    }

    public void setRemoveUnusedFields(Boolean removeUnusedFields) {
        this.removeUnusedFields = removeUnusedFields;
    }

    public Boolean getIgnoreSerializableMethods() {
        return this.ignoreSerializableMethods;
    }

    public void setIgnoreSerializableMethods(Boolean ignoreSerializableMethods) {
        this.ignoreSerializableMethods = ignoreSerializableMethods;
    }

    public Boolean getRemoveUnusedEnumerations() {
        return this.removeUnusedEnumerations;
    }

    public void setRemoveUnusedEnumerations(Boolean removeUnusedEnumerations) {
        this.removeUnusedEnumerations = removeUnusedEnumerations;
    }

    private class TypeUpdater<T>
    extends VoidVisitorAdapter<T> {
        CleanDeadDeclarationsVisitor<T> visitor;

        public TypeUpdater(CleanDeadDeclarationsVisitor<T> visitor) {
            this.visitor = visitor;
        }

        public void visit(ClassOrInterfaceType n, T ctx) {
            SymbolDefinition def = n.getSymbolDefinition();
            if (def != null) {
                Node parent = ((Node)def).getParentNode();
                List usages = def.getUsages();
                Iterator it = usages.iterator();
                boolean finish = false;
                while (it.hasNext() && !finish) {
                    SymbolReference ref = (SymbolReference)it.next();
                    if (ref != n) continue;
                    it.remove();
                    if (parent != null) {
                        parent.accept(this.visitor, ctx);
                    }
                    finish = true;
                }
            }
        }
    }
}

