/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.writers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.walkmod.ChainWriter;
import org.walkmod.walkers.VisitorContext;
import org.walkmod.writers.Summary;

public abstract class AbstractFileWriter
implements ChainWriter {
    private String[] excludes;
    private String[] includes;
    private File outputDirectory;
    private String normalizedOutputDirectory;
    private String encoding = "UTF-8";
    private String platform = null;
    private static final String UNIX = "unix";
    private static final String MAC = "mac";
    private static final String WINDOWS = "windows";
    private boolean createdEmptyFile = false;
    private static Logger log = Logger.getLogger(AbstractFileWriter.class);

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = new File(outputDirectory);
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdir();
        }
        this.normalizedOutputDirectory = FilenameUtils.normalize((String)this.outputDirectory.getAbsolutePath(), (boolean)true);
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public abstract File createOutputDirectory(Object var1);

    protected boolean isValid(File out) throws IOException {
        boolean write = true;
        if (out != null) {
            int i;
            String aux = FilenameUtils.normalize((String)out.getCanonicalPath(), (boolean)true);
            if (this.excludes != null) {
                for (i = 0; i < this.excludes.length && write; ++i) {
                    if (!this.excludes[i].startsWith(this.normalizedOutputDirectory)) {
                        this.excludes[i] = this.normalizedOutputDirectory + "/" + this.excludes[i];
                        if (this.excludes[i].endsWith("\\*\\*")) {
                            this.excludes[i] = this.excludes[i].substring(0, this.excludes[i].length() - 2);
                        }
                    }
                    write = !this.excludes[i].startsWith(aux) && !FilenameUtils.wildcardMatch((String)aux, (String)this.excludes[i]);
                }
            }
            if (this.includes != null && write) {
                write = false;
                for (i = 0; i < this.includes.length && !write; ++i) {
                    if (!this.includes[i].startsWith(this.normalizedOutputDirectory)) {
                        this.includes[i] = this.normalizedOutputDirectory + "/" + this.includes[i];
                        if (this.includes[i].endsWith("\\*\\*")) {
                            this.includes[i] = this.includes[i].substring(0, this.includes[i].length() - 2);
                        }
                    }
                    write = this.includes[i].startsWith(aux) || FilenameUtils.wildcardMatch((String)aux, (String)this.includes[i]);
                }
            }
        }
        return write;
    }

    public boolean requiresToAppend(VisitorContext vc) {
        return vc.get("append") == null || !Boolean.TRUE.equals(vc.get("append"));
    }

    protected Writer getWriter(File out) throws UnsupportedEncodingException, FileNotFoundException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(out), this.getEncoding()));
    }

    protected File getOutputFile(Object n, VisitorContext vc) {
        File out = null;
        if (vc != null) {
            out = (File)vc.get("original_file_key");
        }
        if (out == null) {
            log.debug((Object)"Creating the target source file. This is not the original source file.");
            out = this.createOutputDirectory(n);
            this.createdEmptyFile = true;
        } else {
            log.debug((Object)"The system will overwrite the original source file.");
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(Object n, VisitorContext vc) throws Exception {
        File out = this.getOutputFile(n, vc);
        if (out != null) {
            if (this.isValid(out)) {
                Writer writer = null;
                try {
                    vc.put("outFile", (Object)out);
                    String content = this.getContent(n, vc);
                    vc.remove("outFile");
                    if (content == null || "".equals(content)) return;
                    char endLineChar = this.getEndLineChar(out);
                    writer = this.getWriter(out);
                    if (this.requiresToAppend(vc)) {
                        this.append(content, writer, endLineChar);
                    } else {
                        this.write(content, writer, endLineChar);
                    }
                    Summary.getInstance().addFile(out);
                    log.debug((Object)(out.getPath() + " written "));
                    return;
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            } else {
                if (this.createdEmptyFile && out != null && out.isFile()) {
                    out.delete();
                }
                log.debug((Object)("skipping " + out.getParent()));
            }
            return;
        } else {
            log.debug((Object)"There is no place where to write.");
        }
    }

    public void write(String content, Writer writer, char endLineChar) throws IOException {
        char[] buffer = content.toCharArray();
        String endLine = "\n";
        if (endLineChar == '\r') {
            endLine = "\r\n";
        }
        if (this.platform != null) {
            if (this.platform.equals(UNIX)) {
                endLine = "\n";
            } else if (this.platform.equals(WINDOWS)) {
                endLine = "\r\n";
            } else if (this.platform.equals(MAC)) {
                endLine = "\r";
            }
        }
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] == '\n') {
                writer.write(endLine);
                continue;
            }
            if (buffer[i] == '\r') {
                writer.write(endLine);
                if (i + 1 >= buffer.length || buffer[i + 1] != '\n') continue;
                ++i;
                continue;
            }
            writer.write(buffer[i]);
        }
    }

    public void append(String content, Writer writer, char endLineChar) throws IOException {
        BufferedReader reader = new BufferedReader(new StringReader(content));
        String line = reader.readLine();
        String endLine = "\n";
        if (endLineChar == '\r') {
            endLine = "\r\n";
        }
        while (line != null) {
            writer.append(line + endLine);
            line = reader.readLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char getEndLineChar(File file) throws IOException {
        int endLineChar = 10;
        if (file.exists()) {
            FileReader reader = new FileReader(file);
            try {
                char[] buffer = new char[150];
                boolean detected = false;
                int bytes = reader.read(buffer);
                int previousChar = 0;
                while (bytes > 0 && !detected) {
                    for (int i = 0; i < bytes && !detected; ++i) {
                        if (buffer[i] == '\r') {
                            endLineChar = 13;
                            detected = true;
                        }
                        detected = detected || previousChar == 10 && buffer[i] != '\r';
                        previousChar = buffer[i];
                    }
                    if (detected) continue;
                    bytes = reader.read(buffer);
                }
            }
            finally {
                reader.close();
            }
        } else {
            String os = System.getProperty("os.name");
            if (os.toLowerCase().startsWith(WINDOWS)) {
                endLineChar = 13;
            }
        }
        return (char)endLineChar;
    }

    public abstract String getContent(Object var1, VisitorContext var2);

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void setPath(String path) {
        this.setOutputDirectory(path);
    }

    @Override
    public String getPath() {
        return this.outputDirectory.getPath();
    }

    @Override
    public void setExcludes(String[] excludes) {
        if (excludes != null && System.getProperty("os.name").toLowerCase().contains(WINDOWS)) {
            for (int i = 0; i < excludes.length; ++i) {
                excludes[i] = FilenameUtils.normalize((String)excludes[i], (boolean)true);
            }
        }
        this.excludes = excludes;
    }

    @Override
    public String[] getExcludes() {
        return this.excludes;
    }

    @Override
    public void setIncludes(String[] includes) {
        if (includes != null && System.getProperty("os.name").toLowerCase().contains(WINDOWS)) {
            for (int i = 0; i < includes.length; ++i) {
                includes[i] = FilenameUtils.normalize((String)includes[i], (boolean)true);
            }
        }
        this.includes = includes;
    }

    @Override
    public String[] getIncludes() {
        return this.includes;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
        log.debug((Object)("[encoding]:" + encoding));
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }
}

