/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ClassLoaderUtil {
    private static Map<String, Class<?>> primitiveClasses = new HashMap();
    private static Map<String, String> wrapperClasses = new HashMap<String, String>();
    private static Map<String, Integer> matrixTypePosition;
    private static boolean[][] compatibilityMatrix;
    private static Set<String> langPackageContent;

    public static boolean belongsToLangPackage(String clazz) {
        return langPackageContent.contains(clazz);
    }

    public static boolean isCompatible(Class<?> fromClass, Class<?> toClass) {
        if (fromClass == null || toClass == null) {
            return true;
        }
        if (matrixTypePosition.containsKey(fromClass.getName()) && matrixTypePosition.containsKey(toClass.getName())) {
            return compatibilityMatrix[matrixTypePosition.get(fromClass.getName())][matrixTypePosition.get(toClass.getName())];
        }
        return toClass.isAssignableFrom(fromClass);
    }

    public static boolean isPrimitiveWrapperClass(Class<?> clazz) {
        return wrapperClasses.containsKey(clazz.getName());
    }

    public static Class<?> getPrimitiveClass(Class<?> wrapperClazz) {
        if (ClassLoaderUtil.isPrimitiveWrapperClass(wrapperClazz)) {
            return ClassLoaderUtil.getPrimitiveClass(wrapperClasses.get(wrapperClazz.getName()));
        }
        return null;
    }

    public static Class<?> getPrimitiveClass(String name) {
        return primitiveClasses.get(name);
    }

    public static boolean isCompatible(Class<?>[] fromClasses, Class<?>[] toClasses) {
        if (fromClasses.length == toClasses.length) {
            boolean assignable = true;
            for (int i = 0; i < fromClasses.length && assignable; ++i) {
                assignable = ClassLoaderUtil.isCompatible(fromClasses[i], toClasses[i]);
            }
            return assignable;
        }
        return false;
    }

    public Method getMethod(Class<?> clazz, String methodName, Class<?> ... typeArgs) {
        int i;
        Class<?>[] methodParameterTypes;
        boolean isCompatible;
        Method[] classMethods;
        int numParams = typeArgs == null ? 0 : typeArgs.length;
        for (Method method : classMethods = clazz.getMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != numParams) continue;
            isCompatible = true;
            methodParameterTypes = method.getParameterTypes();
            for (i = 0; i < methodParameterTypes.length && (isCompatible = ClassLoaderUtil.isCompatible(typeArgs[i], methodParameterTypes[i])); ++i) {
            }
            if (!isCompatible) continue;
            return method;
        }
        for (Method method : classMethods = clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || method.getParameterTypes().length != numParams) continue;
            isCompatible = true;
            methodParameterTypes = method.getParameterTypes();
            for (i = 0; i < methodParameterTypes.length && (isCompatible = ClassLoaderUtil.isCompatible(typeArgs[i], methodParameterTypes[i])); ++i) {
            }
            if (!isCompatible) continue;
            return method;
        }
        Method result = null;
        if (clazz.isMemberClass()) {
            result = this.getMethod(clazz.getEnclosingClass(), methodName, typeArgs);
        }
        if (result == null && clazz.getSuperclass() != null) {
            return this.getMethod(clazz.getSuperclass(), methodName, typeArgs);
        }
        return result;
    }

    public static Iterator<URL> getResources(String resourceName, Class<?> callingClass, boolean aggregate) throws IOException {
        ClassLoader cl;
        AggregateIterator<URL> iterator = new AggregateIterator<URL>();
        iterator.addEnumeration(Thread.currentThread().getContextClassLoader().getResources(resourceName));
        if (!iterator.hasNext() || aggregate) {
            iterator.addEnumeration(ClassLoaderUtil.class.getClassLoader().getResources(resourceName));
        }
        if ((!iterator.hasNext() || aggregate) && (cl = callingClass.getClassLoader()) != null) {
            iterator.addEnumeration(cl.getResources(resourceName));
        }
        if (!(iterator.hasNext() || resourceName == null || resourceName.length() != 0 && resourceName.charAt(0) == '/')) {
            return ClassLoaderUtil.getResources('/' + resourceName, callingClass, aggregate);
        }
        return iterator;
    }

    public static URL getResource(String resourceName, Class<?> callingClass) {
        ClassLoader cl;
        URL url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (url == null) {
            url = ClassLoaderUtil.class.getClassLoader().getResource(resourceName);
        }
        if (url == null && (cl = callingClass.getClassLoader()) != null) {
            url = cl.getResource(resourceName);
        }
        if (url == null && resourceName != null && (resourceName.length() == 0 || resourceName.charAt(0) != '/')) {
            return ClassLoaderUtil.getResource('/' + resourceName, callingClass);
        }
        return url;
    }

    public static InputStream getResourceAsStream(String resourceName, Class<?> callingClass) {
        URL url = ClassLoaderUtil.getResource(resourceName, callingClass);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Class<?> loadClass(String className, Class<?> callingClass) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                try {
                    return ClassLoaderUtil.class.getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException exc) {
                    return callingClass.getClassLoader().loadClass(className);
                }
            }
        }
    }

    static {
        primitiveClasses.put("boolean", Boolean.TYPE);
        primitiveClasses.put("int", Integer.TYPE);
        primitiveClasses.put("long", Long.TYPE);
        primitiveClasses.put("double", Double.TYPE);
        primitiveClasses.put("char", Character.TYPE);
        primitiveClasses.put("float", Float.TYPE);
        primitiveClasses.put("short", Short.TYPE);
        primitiveClasses.put("byte", Byte.TYPE);
        matrixTypePosition = new HashMap<String, Integer>();
        matrixTypePosition.put("byte", 0);
        matrixTypePosition.put("java.lang.Byte", 0);
        matrixTypePosition.put("short", 1);
        matrixTypePosition.put("char", 2);
        matrixTypePosition.put("java.lang.Character", 2);
        matrixTypePosition.put("int", 3);
        matrixTypePosition.put("java.lang.Integer", 3);
        matrixTypePosition.put("long", 4);
        matrixTypePosition.put("java.lang.Long", 4);
        matrixTypePosition.put("float", 5);
        matrixTypePosition.put("java.lang.Float", 5);
        matrixTypePosition.put("double", 6);
        matrixTypePosition.put("java.lang.Double", 6);
        matrixTypePosition.put("boolean", 7);
        matrixTypePosition.put("java.lang.Boolean", 7);
        matrixTypePosition.put("String", 8);
        matrixTypePosition.put("java.lang.String", 8);
        matrixTypePosition.put("java.lang.Object", 9);
        wrapperClasses.put("java.lang.Byte", "byte");
        wrapperClasses.put("java.lang.Character", "char");
        wrapperClasses.put("java.lang.Integer", "int");
        wrapperClasses.put("java.lang.Long", "long");
        wrapperClasses.put("java.lang.Float", "float");
        wrapperClasses.put("java.lang.Double", "double");
        wrapperClasses.put("java.lang.Boolean", "boolean");
        compatibilityMatrix = new boolean[][]{{true, true, true, true, true, true, true, false, false, true}, {false, true, false, true, true, true, true, false, false, true}, {false, false, true, true, true, true, true, false, false, true}, {false, false, false, true, true, true, true, false, false, true}, {false, false, false, false, true, true, true, false, false, true}, {false, false, false, false, false, true, true, false, false, true}, {false, false, false, false, false, false, true, false, false, true}, {false, false, false, false, false, false, false, true, false, true}, {false, false, false, false, false, false, false, false, true, true}, {false, false, false, false, false, false, false, false, false, true}};
        langPackageContent = new HashSet<String>();
        langPackageContent.add("Appendable");
        langPackageContent.add("CharSequence");
        langPackageContent.add("Cloneable");
        langPackageContent.add("Comparable");
        langPackageContent.add("Iterable");
        langPackageContent.add("Readable");
        langPackageContent.add("Runnable");
        langPackageContent.add("Thread$UncaughtExceptionHandler");
        langPackageContent.add("Boolean");
        langPackageContent.add("Byte");
        langPackageContent.add("Character");
        langPackageContent.add("Character$Subset");
        langPackageContent.add("Character$UnicodeBlock");
        langPackageContent.add("Class");
        langPackageContent.add("ClassLoader");
        langPackageContent.add("Compiler");
        langPackageContent.add("Double");
        langPackageContent.add("Enum");
        langPackageContent.add("Float");
        langPackageContent.add("InheritableThreadLocal");
        langPackageContent.add("Integer");
        langPackageContent.add("Long");
        langPackageContent.add("Math");
        langPackageContent.add("Number");
        langPackageContent.add("Object");
        langPackageContent.add("Package");
        langPackageContent.add("Process");
        langPackageContent.add("ProcessBuilder");
        langPackageContent.add("Runtime");
        langPackageContent.add("RuntimePermission");
        langPackageContent.add("SecurityManager");
        langPackageContent.add("Short");
        langPackageContent.add("StackTraceElement");
        langPackageContent.add("StrictMath");
        langPackageContent.add("String");
        langPackageContent.add("StringBuffer");
        langPackageContent.add("StringBuilder");
        langPackageContent.add("System");
        langPackageContent.add("Thread");
        langPackageContent.add("ThreadGroup");
        langPackageContent.add("ThreadLocal");
        langPackageContent.add("Throwable");
        langPackageContent.add("Void");
        langPackageContent.add("Thread$State");
        langPackageContent.add("ArithmeticException");
        langPackageContent.add("ArrayIndexOutOfBoundsException");
        langPackageContent.add("ArrayStoreException");
        langPackageContent.add("ClassCastException");
        langPackageContent.add("ClassNotFoundException");
        langPackageContent.add("CloneNotSupportedException");
        langPackageContent.add("EnumConstantNotPresentException");
        langPackageContent.add("Exception");
        langPackageContent.add("IllegalAccessException");
        langPackageContent.add("IllegalArgumentException");
        langPackageContent.add("IllegalMonitorStateException");
        langPackageContent.add("IllegalStateException");
        langPackageContent.add("IllegalThreadStateException");
        langPackageContent.add("IndexOutOfBoundsException");
        langPackageContent.add("InstantiationException");
        langPackageContent.add("InterruptedException");
        langPackageContent.add("NegativeArraySizeException");
        langPackageContent.add("NoSuchFieldException");
        langPackageContent.add("NoSuchMethodException");
        langPackageContent.add("NullPointerException");
        langPackageContent.add("NumberFormatException");
        langPackageContent.add("RuntimeException");
        langPackageContent.add("SecurityException");
        langPackageContent.add("StringIndexOutOfBoundsException");
        langPackageContent.add("TypeNotPresentException");
        langPackageContent.add("UnsupportedOperationException");
        langPackageContent.add("AbstractMethodError");
        langPackageContent.add("AssertionError");
        langPackageContent.add("ClassCircularityError");
        langPackageContent.add("ClassFormatError");
        langPackageContent.add("Error");
        langPackageContent.add("ExceptionInInitializerError");
        langPackageContent.add("IllegalAccessError");
        langPackageContent.add("IncompatibleClassChangeError");
        langPackageContent.add("InstatiationError");
        langPackageContent.add("InternalError");
        langPackageContent.add("LinkageError");
        langPackageContent.add("NoClassDefFoundError");
        langPackageContent.add("NoSuchFieldError");
        langPackageContent.add("NoSuchMethodError");
        langPackageContent.add("OutOfMemoryError");
        langPackageContent.add("StackOverflowError");
        langPackageContent.add("ThreadDeath");
        langPackageContent.add("UnknownError");
        langPackageContent.add("UnsatistiedLinkError");
        langPackageContent.add("UnsupportedClassVersionError");
        langPackageContent.add("VerifyError");
        langPackageContent.add("VirtualMachineError");
        langPackageContent.add("Deprecated");
        langPackageContent.add("Override");
        langPackageContent.add("SuppressWarnings");
    }

    protected static class AggregateIterator<E>
    implements Iterator<E> {
        LinkedList<Enumeration<E>> enums = new LinkedList();
        Enumeration<E> cur = null;
        E next = null;
        Set<E> loaded = new HashSet();

        protected AggregateIterator() {
        }

        public AggregateIterator<E> addEnumeration(Enumeration<E> e) {
            if (e.hasMoreElements()) {
                if (this.cur == null) {
                    this.cur = e;
                    this.next = e.nextElement();
                    this.loaded.add(this.next);
                } else {
                    this.enums.add(e);
                }
            }
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.next != null) {
                E prev = this.next;
                this.next = this.loadNext();
                return prev;
            }
            throw new NoSuchElementException();
        }

        private Enumeration<E> determineCurrentEnumeration() {
            if (this.cur != null && !this.cur.hasMoreElements()) {
                this.cur = this.enums.size() > 0 ? this.enums.removeLast() : null;
            }
            return this.cur;
        }

        private E loadNext() {
            if (this.determineCurrentEnumeration() != null) {
                E tmp = this.cur.nextElement();
                while (this.loaded.contains(tmp) && (tmp = this.loadNext()) != null) {
                }
                if (tmp != null) {
                    this.loaded.add(tmp);
                }
                return tmp;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

