/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.scripting;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.log4j.Logger;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.jsr223.GroovyScriptEngineImpl;
import org.walkmod.exceptions.WalkModException;
import org.walkmod.query.QueryEngine;
import org.walkmod.query.QueryEngineAware;
import org.walkmod.walkers.VisitorContext;

public class ScriptProcessor
implements QueryEngineAware {
    private String language = "groovy";
    private ScriptEngine engine = null;
    private String location;
    private String content;
    private static Logger log = Logger.getLogger(ScriptProcessor.class);
    private QueryEngine queryEngine;

    public void initialize(VisitorContext context, Object node) {
        if (this.engine == null) {
            ScriptEngineManager factory = new ScriptEngineManager(context.getClassLoader());
            this.engine = factory.getEngineByName(this.language);
            if (this.engine instanceof GroovyScriptEngineImpl) {
                ((GroovyScriptEngineImpl)this.engine).setClassLoader(new GroovyClassLoader(context.getClassLoader(), new CompilerConfiguration()));
            }
        }
        if (this.queryEngine == null) {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("language", "groovy");
            LinkedList<String> includes = new LinkedList<String>();
            includes.add("query.alias.groovy");
            parameters.put("includes", includes);
            Object bean = context.getBean("org.walkmod.query.ScriptingQueryEngine", parameters);
            if (bean != null) {
                if (bean instanceof QueryEngine) {
                    this.queryEngine = (QueryEngine)bean;
                }
            } else {
                throw new WalkModException("Query Engine not found");
            }
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("node", node);
        this.queryEngine.initialize(context, params);
    }

    public void visit(Object node, VisitorContext ctx) {
        this.initialize(ctx, node);
        Bindings bindings = this.engine.createBindings();
        bindings.put("node", node);
        bindings.put("context", (Object)ctx);
        bindings.put("query", (Object)this.getQueryEngine());
        if (this.content != null) {
            try {
                this.engine.eval(this.content, bindings);
            }
            catch (ScriptException e) {
                log.error((Object)("The file " + e.getFileName() + " has an error at line: " + e.getLineNumber() + ", column: " + e.getColumnNumber()));
                throw new WalkModException(e);
            }
        }
        if (this.location != null) {
            FileReader reader = null;
            File file = new File(this.location).getAbsoluteFile();
            if (file.exists()) {
                try {
                    reader = new FileReader(file);
                }
                catch (FileNotFoundException e) {
                    throw new WalkModException(e);
                }
            }
            URL uri = ctx.getClassLoader().getResource(this.location);
            if (uri != null) {
                try {
                    reader = new FileReader(new File(uri.getFile()));
                }
                catch (FileNotFoundException e) {
                    throw new WalkModException(e);
                }
            }
            if (reader != null) {
                try {
                    this.engine.eval((Reader)reader, bindings);
                }
                catch (ScriptException e) {
                    throw new WalkModException(e);
                }
            }
        }
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setContent(String content) {
        this.content = content;
    }

    @Override
    public void setQueryEngine(QueryEngine queryEngine) {
        this.queryEngine = queryEngine;
    }

    @Override
    public QueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    @Override
    public Object query(String query) {
        if (this.queryEngine != null) {
            return this.queryEngine.resolve(query);
        }
        return null;
    }

    @Override
    public Object query(Object context, String query) {
        if (this.queryEngine != null) {
            return this.queryEngine.resolve(context, query);
        }
        return null;
    }
}

