/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.patches;

import difflib.DiffUtils;
import difflib.Patch;
import difflib.PatchFailedException;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Patches {
    public static String generatePatch(String originalText, String text, String location) {
        List<String> original = Arrays.asList(originalText.split("\n"));
        List<String> revised = Arrays.asList(text.split("\n"));
        Patch patches = DiffUtils.diff(original, revised);
        List unifiedDiffs = DiffUtils.generateUnifiedDiff((String)("a" + File.separator + location), (String)("b" + File.separator + location), original, (Patch)patches, (int)4);
        Iterator it = unifiedDiffs.iterator();
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String applyPatch(String text, String patch) throws PatchFailedException {
        List<String> original = Arrays.asList(text.split("\n"));
        List<String> diff = Arrays.asList(patch.split("\n"));
        Patch generatedPatch = DiffUtils.parseUnifiedDiff(diff);
        Iterator it = DiffUtils.patch(original, (Patch)generatedPatch).iterator();
        StringBuffer sb = new StringBuffer();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append('\n');
        }
        return sb.toString();
    }
}

