/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.patches;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.walkmod.patches.Patch;
import org.walkmod.patches.PatchFormatter;

public class JsonPatchFormatter
implements PatchFormatter {
    private ObjectMapper mapper = new ObjectMapper();

    @Override
    public String format(Patch patch) {
        try {
            return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)patch);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String format(String location, List<Patch> patches) {
        JSONObject object = new JSONObject();
        object.put("file", (Object)location);
        object.put("patches", patches);
        try {
            return this.mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

