/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.walkmod.ChainAdapter;
import org.walkmod.ChainWalker;
import org.walkmod.ChainWalkerAdapter;
import org.walkmod.ChainWalkerInvocation;
import org.walkmod.ChainWriter;
import org.walkmod.Resource;
import org.walkmod.ResourceModifier;
import org.walkmod.conf.entities.ChainConfig;
import org.walkmod.conf.entities.Configuration;
import org.walkmod.conf.entities.TransformationConfig;
import org.walkmod.conf.entities.WalkerConfig;
import org.walkmod.exceptions.WalkModException;
import org.walkmod.walkers.Parser;
import org.walkmod.walkers.ParserAware;

public class DefaultChainWalkerAdapter
implements ChainWalkerAdapter {
    private WalkerConfig config;
    private ChainWalker walker;
    private List<Object> visitors = new LinkedList<Object>();
    private String name;
    private ChainWalkerInvocation wi;
    private ChainAdapter ap;
    private Collection<TransformationConfig> transformationConfigs;
    private static final Log LOG = LogFactory.getLog(DefaultChainWalkerAdapter.class);

    @Override
    public Resource<?> getModel() {
        return this.ap.getResource();
    }

    @Override
    public void setWalker(ChainWalker walker) {
        this.walker = walker;
    }

    @Override
    public ChainWalker getWalker() {
        return this.walker;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void prepare() throws WalkModException {
        Collection<TransformationConfig> cfgs;
        this.walker.setResource(this.getModel());
        this.walker.setRootNamespace(this.config.getRootNamespace());
        ChainWriter mw = this.ap.getChainWriter();
        mw.setExcludes(this.config.getChainConfig().getWriterConfig().getExcludes());
        mw.setIncludes(this.config.getChainConfig().getWriterConfig().getIncludes());
        this.walker.setWriter(this.ap.getChainWriter());
        this.walker.setChainConfig(this.config.getChainConfig());
        ChainConfig ac = this.config.getChainConfig();
        Configuration c = ac.getConfiguration();
        Parser parser = null;
        String parserType = this.config.getParserConfig().getType();
        if (parserType != null) {
            Object parserInstance = c.getBean(parserType, this.config.getParserConfig().getParameters());
            if (parserInstance == null) throw new WalkModException("The parser " + parserType + " does not exist.");
            if (!(parserInstance instanceof Parser)) throw new WalkModException("The parser " + parserType + " must implement " + Parser.class.getName());
            parser = (Parser)parserInstance;
            this.walker.setParser(parser);
        }
        if ((cfgs = this.getTransformationConfig()) != null) {
            for (TransformationConfig config : cfgs) {
                this.setName(config.getName());
                Object visitor = config.getVisitorInstance();
                if (visitor == null || "".equals(config.getType())) {
                    visitor = c.getBean(config.getType(), config.getParameters());
                }
                if (visitor instanceof ResourceModifier) {
                    ((ResourceModifier)visitor).setResource(this.getModel());
                }
                if (visitor instanceof ParserAware) {
                    ((ParserAware)visitor).setParser(parser);
                }
                if (visitor != null) {
                    LOG.debug((Object)("setting chain[\"" + ac.getName() + "\"].transformation[\"" + this.getName() + "\"].walker = " + this.walker.getClass().getName()));
                    LOG.debug((Object)("setting chain[\"" + ac.getName() + "\"].transformation[\"" + this.getName() + "\"].visitor = " + visitor.getClass().getName()));
                    this.visitors.add(visitor);
                    continue;
                }
                this.walker = null;
                visitor = null;
                LOG.debug((Object)("Transformation[" + this.getName() + "] without walker and visitor"));
            }
        }
        this.walker.setVisitors(this.visitors);
        this.wi.init(this);
    }

    @Override
    public void execute() throws WalkModException {
        this.wi.invoke();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setWalkerInvocation(ChainWalkerInvocation wi) {
        this.wi = wi;
    }

    @Override
    public ChainWalkerInvocation getWalkerInvocation() {
        return this.wi;
    }

    @Override
    public ChainAdapter getArchitecture() {
        return this.ap;
    }

    @Override
    public void setArchitectureProxy(ChainAdapter ap) {
        this.ap = ap;
        this.setName(ap.getName());
    }

    @Override
    public void setTransformationConfig(Collection<TransformationConfig> config) {
        this.transformationConfigs = config;
    }

    @Override
    public Collection<TransformationConfig> getTransformationConfig() {
        return this.transformationConfigs;
    }

    @Override
    public void setWalkerConfig(WalkerConfig config) {
        this.config = config;
        this.setTransformationConfig(config.getTransformations());
    }

    @Override
    public WalkerConfig getWalkerConfig() {
        return this.config;
    }
}

