/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.yml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.providers.YAMLConfigurationProvider;
import org.walkmod.conf.providers.yml.AbstractYMLConfigurationAction;

public class SetWriterYMLAction
extends AbstractYMLConfigurationAction {
    private String chain;
    private String type;
    private String path;
    private Map<String, String> params;

    public SetWriterYMLAction(String chain, String type, String path, YAMLConfigurationProvider provider, boolean recursive, Map<String, String> params) {
        super(provider, recursive);
        this.chain = chain;
        this.type = type;
        this.path = path;
        this.params = params;
    }

    @Override
    public void doAction(JsonNode node) throws Exception {
        ObjectNode writer = null;
        ObjectMapper mapper = this.provider.getObjectMapper();
        if (node.has("chains") && (this.chain == null || "".equals(this.chain.trim()))) {
            this.chain = "default";
        }
        if (this.chain != null && !"".equals(this.chain.trim())) {
            JsonNode chainsListNode;
            if (node.has("chains") && (chainsListNode = node.get("chains")).isArray()) {
                Iterator it = chainsListNode.iterator();
                boolean found = false;
                while (it.hasNext() && !found) {
                    String name;
                    JsonNode current = (JsonNode)it.next();
                    if (!current.has("name") || !(found = (name = current.get("name").asText()).equals(this.chain))) continue;
                    writer = current.has("writer") ? (ObjectNode)current.get("writer") : new ObjectNode(mapper.getNodeFactory());
                    if (this.type != null && !"".equals(this.type.trim())) {
                        writer.set("type", (JsonNode)new TextNode(this.type));
                    }
                    if (this.path != null && !"".equals(this.path.trim())) {
                        writer.set("path", (JsonNode)new TextNode(this.path));
                    }
                    if (this.params == null || this.params.isEmpty()) continue;
                    ObjectNode paramsObject = null;
                    if (writer.has("params")) {
                        paramsObject = (ObjectNode)writer.get("params");
                    } else {
                        paramsObject = new ObjectNode(mapper.getNodeFactory());
                        writer.set("params", (JsonNode)paramsObject);
                    }
                    Set<String> keys = this.params.keySet();
                    for (String key : keys) {
                        paramsObject.put(key, this.params.get(key).toString());
                    }
                }
            }
            if (writer != null) {
                this.provider.write(node);
            }
        } else if (!node.has("chains")) {
            ArrayNode chains = new ArrayNode(mapper.getNodeFactory());
            ObjectNode defaultChain = new ObjectNode(mapper.getNodeFactory());
            defaultChain.set("name", (JsonNode)new TextNode("default"));
            ObjectNode writerNode = new ObjectNode(mapper.getNodeFactory());
            if (this.type != null && !"".equals(this.type.trim())) {
                writerNode.set("type", (JsonNode)new TextNode(this.type));
            }
            if (this.path != null && !"".equals(this.path.trim())) {
                writerNode.set("path", (JsonNode)new TextNode(this.path));
            }
            if (this.params != null && !this.params.isEmpty()) {
                ObjectNode paramsObject = new ObjectNode(mapper.getNodeFactory());
                Set<String> keys = this.params.keySet();
                for (String key : keys) {
                    paramsObject.put(key, this.params.get(key).toString());
                }
                writerNode.set("params", (JsonNode)paramsObject);
            }
            if (node.has("transformations")) {
                defaultChain.set("transformations", node.get("transformations"));
            }
            defaultChain.set("writer", (JsonNode)writerNode);
            chains.add((JsonNode)defaultChain);
            ObjectNode root = new ObjectNode(mapper.getNodeFactory());
            root.set("chains", (JsonNode)chains);
            this.provider.write((JsonNode)root);
        }
    }

    @Override
    public AbstractYMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new SetWriterYMLAction(this.chain, this.type, this.path, (YAMLConfigurationProvider)provider, recursive, this.params);
    }
}

