/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.yml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.providers.YAMLConfigurationProvider;
import org.walkmod.conf.providers.yml.AbstractYMLConfigurationAction;

public class RemoveTransformationYMLAction
extends AbstractYMLConfigurationAction {
    private String chain;
    private List<String> transformations;

    public RemoveTransformationYMLAction(String chain, List<String> transformations, YAMLConfigurationProvider provider, boolean recursive) {
        super(provider, recursive);
        this.chain = chain;
        this.transformations = transformations;
    }

    @Override
    public void doAction(JsonNode node) throws Exception {
        Iterator it;
        JsonNode chainsListNode;
        HashSet<String> transList = new HashSet<String>(this.transformations);
        JsonNode transfListNode = null;
        if (this.chain == null || "".equals(this.chain)) {
            if (node.has("transformations")) {
                transfListNode = node.get("transformations");
            }
        } else if (node.has("chains") && (chainsListNode = node.get("chains")).isArray()) {
            it = chainsListNode.iterator();
            boolean found = false;
            while (it.hasNext() && !found) {
                JsonNode current = (JsonNode)it.next();
                if (!current.has("name")) continue;
                String name = current.get("name").asText();
                found = name.equals(this.chain);
                if (!current.has("transformations")) continue;
                transfListNode = current.get("transformations");
            }
        }
        if (transfListNode != null) {
            if (transfListNode.isArray()) {
                ArrayNode transArray = (ArrayNode)transfListNode;
                it = transArray.iterator();
                LinkedList<Integer> removeIndex = new LinkedList<Integer>();
                int i = 0;
                while (it.hasNext()) {
                    String type;
                    JsonNode transfNode = (JsonNode)it.next();
                    if (transfNode.has("type") && transList.contains(type = transfNode.get("type").asText())) {
                        removeIndex.add(i);
                    }
                    ++i;
                }
                for (Integer pos : removeIndex) {
                    transArray.remove(pos.intValue());
                }
            }
            this.provider.write(node);
        }
    }

    @Override
    public AbstractYMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new RemoveTransformationYMLAction(this.chain, this.transformations, (YAMLConfigurationProvider)provider, recursive);
    }
}

