/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.yml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.providers.YAMLConfigurationProvider;
import org.walkmod.conf.providers.yml.AbstractYMLConfigurationAction;

public class RemoveProvidersYMLAction
extends AbstractYMLConfigurationAction {
    private List<String> providers;

    public RemoveProvidersYMLAction(List<String> providers, YAMLConfigurationProvider provider, boolean recursive) {
        super(provider, recursive);
        this.providers = providers;
    }

    @Override
    public void doAction(JsonNode node) throws Exception {
        JsonNode aux;
        HashSet<String> providerSet = new HashSet<String>();
        for (String elem : this.providers) {
            String[] partsType = elem.split(":");
            if (partsType.length == 1) {
                elem = "org.walkmod:walkmod-" + elem + "-plugin:" + elem;
            }
            if (partsType.length != 3 && partsType.length != 1) {
                throw new TransformerException("Invalid conf-provider");
            }
            providerSet.add(elem);
        }
        if (node.has("conf-providers") && (aux = node.get("conf-providers")).isArray()) {
            ArrayNode providersList = (ArrayNode)node.get("conf-providers");
            Iterator it = providersList.iterator();
            ArrayNode newProvidersList = new ArrayNode(this.provider.getObjectMapper().getNodeFactory());
            while (it.hasNext()) {
                JsonNode next = (JsonNode)it.next();
                if (!next.isObject()) continue;
                String type = next.get("type").asText();
                String[] parts = type.split(":");
                if (parts.length == 1) {
                    type = "org.walkmod:walkmod-" + type + "-plugin:" + type;
                } else if (parts.length != 3) {
                    throw new TransformerException("Invalid conf-provider");
                }
                if (providerSet.contains(type)) continue;
                newProvidersList.add(next);
            }
            ObjectNode oNode = (ObjectNode)node;
            if (newProvidersList.size() > 0) {
                oNode.set("conf-providers", (JsonNode)newProvidersList);
            } else {
                oNode.remove("conf-providers");
            }
            this.provider.write(node);
        }
    }

    @Override
    public AbstractYMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new RemoveProvidersYMLAction(this.providers, (YAMLConfigurationProvider)provider, recursive);
    }
}

