/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.yml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Iterator;
import javax.xml.transform.TransformerException;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.PluginConfig;
import org.walkmod.conf.providers.YAMLConfigurationProvider;
import org.walkmod.conf.providers.yml.AbstractYMLConfigurationAction;

public class RemovePluginYMLAction
extends AbstractYMLConfigurationAction {
    private PluginConfig pluginConfig;

    public RemovePluginYMLAction(PluginConfig pluginConfig, YAMLConfigurationProvider provider, boolean recursive) {
        super(provider, recursive);
        this.pluginConfig = pluginConfig;
    }

    @Override
    public void doAction(JsonNode node) throws Exception {
        if (node.has("plugins")) {
            ArrayNode pluginList = null;
            JsonNode aux = node.get("plugins");
            if (aux.isArray()) {
                pluginList = (ArrayNode)node.get("plugins");
                Iterator it = pluginList.iterator();
                int index = -1;
                int i = 0;
                while (it.hasNext() && index == -1) {
                    String text;
                    String[] parts;
                    JsonNode next = (JsonNode)it.next();
                    if (next.isTextual() && (parts = (text = next.asText()).split(":")).length >= 2 && parts[0].equals(this.pluginConfig.getGroupId()) && parts[1].equals(this.pluginConfig.getArtifactId())) {
                        index = i;
                    }
                    ++i;
                }
                if (index > -1) {
                    pluginList.remove(index);
                }
            } else {
                throw new TransformerException("The plugins element is not a valid array");
            }
        }
        this.provider.write(node);
    }

    @Override
    public AbstractYMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new RemovePluginYMLAction(this.pluginConfig, (YAMLConfigurationProvider)provider, recursive);
    }
}

