/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.yml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.providers.YAMLConfigurationProvider;
import org.walkmod.conf.providers.yml.AbstractYMLConfigurationAction;

public class RemoveIncludesOrExcludesYMLAction
extends AbstractYMLConfigurationAction {
    private List<String> includes;
    private String chain;
    private boolean setToReader;
    private boolean setToWriter;
    private boolean isExcludes;

    public RemoveIncludesOrExcludesYMLAction(List<String> includes, String chain, boolean recursive, boolean setToReader, boolean setToWriter, boolean isExcludes, YAMLConfigurationProvider provider) {
        super(provider, recursive);
        this.includes = includes;
        this.chain = chain;
        this.setToReader = setToReader;
        this.setToWriter = setToWriter;
    }

    @Override
    public void doAction(JsonNode node) throws Exception {
        if (this.chain == null) {
            this.chain = "default";
        }
        if (node.has("chains")) {
            JsonNode chains = node.get("chains");
            if (chains.isArray()) {
                ArrayNode chainsArray = (ArrayNode)chains;
                int limit = chainsArray.size();
                JsonNode selectedChain = null;
                for (int i = 0; i < limit && selectedChain == null; ++i) {
                    JsonNode chainNode = chainsArray.get(i);
                    if (!chainNode.has("name") || !chainNode.get("name").asText().equals(this.chain)) continue;
                    selectedChain = chainNode;
                }
                if (selectedChain != null) {
                    if (this.setToReader) {
                        JsonNode reader = null;
                        if (selectedChain.has("reader")) {
                            reader = selectedChain.get("reader");
                        }
                        if (reader != null) {
                            this.removesIncludesOrExcludesList((ObjectNode)reader);
                        }
                    }
                    if (this.setToWriter) {
                        JsonNode writer = null;
                        if (selectedChain.has("writer")) {
                            writer = selectedChain.get("writer");
                        }
                        if (writer != null) {
                            this.removesIncludesOrExcludesList((ObjectNode)writer);
                        }
                    }
                }
            }
            this.provider.write(node);
        }
    }

    private void removesIncludesOrExcludesList(ObjectNode node) {
        JsonNode wildcard;
        ArrayNode wildcardArray = null;
        ArrayNode result = new ArrayNode(this.provider.getObjectMapper().getNodeFactory());
        String label = "includes";
        if (this.isExcludes) {
            label = "excludes";
        }
        if (node.has(label) && (wildcard = node.get(label)).isArray()) {
            wildcardArray = (ArrayNode)wildcard;
        }
        if (wildcardArray != null) {
            int limit = wildcardArray.size();
            for (int i = 0; i < limit; ++i) {
                String aux = wildcardArray.get(i).asText();
                if (this.includes.contains(aux)) continue;
                result.add(wildcardArray.get(i));
            }
        }
        if (result.size() > 0) {
            node.set(label, (JsonNode)result);
        } else {
            node.remove(label);
        }
    }

    @Override
    public AbstractYMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new RemoveIncludesOrExcludesYMLAction(this.includes, this.chain, recursive, this.setToReader, this.setToWriter, this.isExcludes, (YAMLConfigurationProvider)provider);
    }
}

