/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.yml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.providers.YAMLConfigurationProvider;
import org.walkmod.conf.providers.yml.AbstractYMLConfigurationAction;

public class RemoveChainsYMLAction
extends AbstractYMLConfigurationAction {
    private List<String> chains;

    public RemoveChainsYMLAction(List<String> chains, YAMLConfigurationProvider provider, boolean recursive) {
        super(provider, recursive);
        this.chains = chains;
    }

    @Override
    public void doAction(JsonNode node) throws Exception {
        HashSet<String> chainsSet = new HashSet<String>(this.chains);
        ArrayNode chainsList = null;
        ObjectMapper mapper = this.provider.getObjectMapper();
        if (node.has("chains")) {
            JsonNode aux = node.get("chains");
            if (aux.isArray()) {
                chainsList = (ArrayNode)node.get("chains");
                Iterator it = chainsList.iterator();
                ArrayNode newChainsList = new ArrayNode(mapper.getNodeFactory());
                while (it.hasNext()) {
                    String type;
                    JsonNode next = (JsonNode)it.next();
                    if (!next.isObject() || chainsSet.contains(type = next.get("name").asText())) continue;
                    newChainsList.add(next);
                }
                ObjectNode oNode = (ObjectNode)node;
                if (newChainsList.size() > 0) {
                    oNode.set("chains", (JsonNode)newChainsList);
                } else {
                    oNode.remove("chains");
                }
                this.provider.write(node);
            }
        } else if (node.has("transformations") && chainsSet.contains("default")) {
            ObjectNode oNode = (ObjectNode)node;
            oNode.remove("transformations");
            this.provider.write(node);
        }
    }

    @Override
    public AbstractYMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new RemoveChainsYMLAction(this.chains, (YAMLConfigurationProvider)provider, recursive);
    }
}

