/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.yml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Iterator;
import java.util.Map;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.ProviderConfig;
import org.walkmod.conf.providers.YAMLConfigurationProvider;
import org.walkmod.conf.providers.yml.AbstractYMLConfigurationAction;

public class AddProviderConfigYMLAction
extends AbstractYMLConfigurationAction {
    private ProviderConfig providerCfg;

    public AddProviderConfigYMLAction(ProviderConfig providerCfg, YAMLConfigurationProvider provider, boolean recursive) {
        super(provider, recursive);
        this.providerCfg = providerCfg;
    }

    @Override
    public void doAction(JsonNode node) throws Exception {
        ObjectMapper mapper = this.provider.getObjectMapper();
        if (node.has("conf-providers")) {
            JsonNode list = node.get("conf-providers");
            Iterator it = list.iterator();
            boolean found = false;
            while (it.hasNext() && !found) {
                JsonNode next = (JsonNode)it.next();
                found = this.providerCfg.getType().equals(next.get("type").asText());
            }
            if (!found && list.isArray()) {
                ArrayNode aux = (ArrayNode)list;
                ObjectNode prov = new ObjectNode(mapper.getNodeFactory());
                prov.set("type", (JsonNode)new TextNode(this.providerCfg.getType()));
                Map<String, Object> params = this.providerCfg.getParameters();
                if (params != null && !params.isEmpty()) {
                    this.populateParams(prov, params);
                }
                aux.add((JsonNode)prov);
                this.provider.write(node);
                return;
            }
        } else {
            ArrayNode aux = new ArrayNode(mapper.getNodeFactory());
            ObjectNode prov = new ObjectNode(mapper.getNodeFactory());
            prov.set("type", (JsonNode)new TextNode(this.providerCfg.getType()));
            Map<String, Object> params = this.providerCfg.getParameters();
            if (params != null && !params.isEmpty()) {
                this.populateParams(prov, params);
            }
            aux.add((JsonNode)prov);
            ObjectNode auxNode = (ObjectNode)node;
            auxNode.set("conf-providers", (JsonNode)aux);
            this.provider.write(node);
            return;
        }
    }

    @Override
    public AbstractYMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new AddProviderConfigYMLAction(this.providerCfg, (YAMLConfigurationProvider)provider, recursive);
    }
}

