/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.yml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.List;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.providers.YAMLConfigurationProvider;
import org.walkmod.conf.providers.yml.AbstractYMLConfigurationAction;

public class AddIncludesOrExcludesYMLAction
extends AbstractYMLConfigurationAction {
    private List<String> includes;
    private String chain;
    private boolean setToReader;
    private boolean setToWriter;
    private boolean isExcludes;

    public AddIncludesOrExcludesYMLAction(List<String> includes, String chain, boolean recursive, boolean setToReader, boolean setToWriter, boolean isExcludes, YAMLConfigurationProvider provider) {
        super(provider, recursive);
        this.includes = includes;
        this.chain = chain;
        this.setToReader = setToReader;
        this.setToWriter = setToWriter;
        this.isExcludes = isExcludes;
    }

    private void setIncludesOrExcludesList(ObjectNode node) {
        JsonNode wildcard;
        ArrayNode wildcardArray = null;
        String label = "includes";
        if (this.isExcludes) {
            label = "excludes";
        }
        if (node.has(label) && (wildcard = node.get(label)).isArray()) {
            wildcardArray = (ArrayNode)wildcard;
        }
        if (wildcardArray == null) {
            wildcardArray = new ArrayNode(this.provider.getObjectMapper().getNodeFactory());
            node.set(label, (JsonNode)wildcardArray);
        }
        for (String includesItem : this.includes) {
            wildcardArray.add(includesItem);
        }
    }

    @Override
    public void doAction(JsonNode node) throws Exception {
        if (this.chain == null) {
            this.chain = "default";
        }
        ObjectMapper mapper = this.provider.getObjectMapper();
        if (node.has("chains")) {
            JsonNode chains = node.get("chains");
            if (chains.isArray()) {
                ArrayNode chainsArray = (ArrayNode)chains;
                int limit = chainsArray.size();
                ObjectNode selectedChain = null;
                for (int i = 0; i < limit && selectedChain == null; ++i) {
                    JsonNode chainNode = chainsArray.get(i);
                    if (!chainNode.has("name") || !chainNode.get("name").asText().equals(this.chain)) continue;
                    selectedChain = (ObjectNode)chainNode;
                }
                if (selectedChain == null) {
                    selectedChain = new ObjectNode(mapper.getNodeFactory());
                    selectedChain.set("name", (JsonNode)new TextNode(this.chain));
                    chainsArray.add((JsonNode)selectedChain);
                }
                if (this.setToReader) {
                    JsonNode reader = null;
                    if (selectedChain.has("reader")) {
                        reader = selectedChain.get("reader");
                    } else {
                        reader = new ObjectNode(mapper.getNodeFactory());
                        selectedChain.set("reader", reader);
                    }
                    this.setIncludesOrExcludesList((ObjectNode)reader);
                }
                if (this.setToWriter) {
                    JsonNode reader = null;
                    if (selectedChain.has("writer")) {
                        reader = selectedChain.get("writer");
                    } else {
                        reader = new ObjectNode(mapper.getNodeFactory());
                        selectedChain.set("writer", reader);
                    }
                    this.setIncludesOrExcludesList((ObjectNode)reader);
                }
            }
        } else {
            ObjectNode root = (ObjectNode)node;
            if (node.has("transformations")) {
                JsonNode transformations = node.get("transformations");
                root.remove("transformations");
                ObjectNode chainNode = new ObjectNode(mapper.getNodeFactory());
                chainNode.set("name", (JsonNode)new TextNode("default"));
                chainNode.set("transformations", transformations);
                ArrayNode chains = new ArrayNode(mapper.getNodeFactory());
                chains.add((JsonNode)chainNode);
                if (!this.chain.equals("default")) {
                    chainNode = new ObjectNode(mapper.getNodeFactory());
                    chainNode.set("name", (JsonNode)new TextNode(this.chain));
                    chains.add((JsonNode)chainNode);
                }
                ObjectNode reader = new ObjectNode(mapper.getNodeFactory());
                this.setIncludesOrExcludesList(reader);
                chainNode.set("reader", (JsonNode)reader);
                ObjectNode writer = new ObjectNode(mapper.getNodeFactory());
                this.setIncludesOrExcludesList(writer);
                chainNode.set("writer", (JsonNode)writer);
                root.set("chains", (JsonNode)chains);
            } else if (!node.has("modules")) {
                ObjectNode chainNode = new ObjectNode(mapper.getNodeFactory());
                chainNode.set("name", (JsonNode)new TextNode("default"));
                ArrayNode chains = new ArrayNode(mapper.getNodeFactory());
                chains.add((JsonNode)chainNode);
                ObjectNode reader = new ObjectNode(mapper.getNodeFactory());
                this.setIncludesOrExcludesList(reader);
                chainNode.set("reader", (JsonNode)reader);
                ObjectNode writer = new ObjectNode(mapper.getNodeFactory());
                this.setIncludesOrExcludesList(writer);
                chainNode.set("writer", (JsonNode)writer);
                root.set("chains", (JsonNode)chains);
            }
        }
        this.provider.write(node);
    }

    @Override
    public AbstractYMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new AddIncludesOrExcludesYMLAction(this.includes, this.chain, recursive, this.setToReader, this.setToWriter, this.isExcludes, (YAMLConfigurationProvider)provider);
    }
}

