/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.yml;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.ChainConfig;
import org.walkmod.conf.entities.ReaderConfig;
import org.walkmod.conf.entities.TransformationConfig;
import org.walkmod.conf.entities.WalkerConfig;
import org.walkmod.conf.entities.WriterConfig;
import org.walkmod.conf.providers.YAMLConfigurationProvider;
import org.walkmod.conf.providers.yml.AbstractYMLConfigurationAction;

public class AddChainYMLAction
extends AbstractYMLConfigurationAction {
    private ChainConfig chainCfg;
    private String before;

    public AddChainYMLAction(ChainConfig chainCfg, YAMLConfigurationProvider provider, boolean recursive, String before) {
        super(provider, recursive);
        this.chainCfg = chainCfg;
        this.before = before;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doAction(JsonNode chainsNode) throws Exception {
        WriterConfig writerCfg;
        ArrayNode chainsList = null;
        ObjectMapper mapper = this.provider.getObjectMapper();
        if (chainsNode != null) {
            JsonNode aux;
            if (!chainsNode.has("chains")) {
                chainsList = new ArrayNode(mapper.getNodeFactory());
                if (!chainsNode.isObject()) throw new TransformerException("The root element is not a JSON node");
                aux = (ObjectNode)chainsNode;
                aux.set("chains", (JsonNode)chainsList);
            } else {
                aux = chainsNode.get("chains");
                if (!aux.isArray()) throw new TransformerException("The plugins element is not a valid array");
                chainsList = (ArrayNode)chainsNode.get("chains");
            }
        }
        ObjectNode chainNode = new ObjectNode(mapper.getNodeFactory());
        ReaderConfig readerCfg = this.chainCfg.getReaderConfig();
        if (readerCfg != null) {
            if (chainsNode == null) {
                chainsNode = new ObjectNode(mapper.getNodeFactory());
                ObjectNode aux = (ObjectNode)chainsNode;
                chainsList = new ArrayNode(mapper.getNodeFactory());
                aux.set("chains", (JsonNode)chainsList);
            }
            ObjectNode readerNode = new ObjectNode(mapper.getNodeFactory());
            chainNode.set("reader", (JsonNode)readerNode);
            this.populateWriterReader(readerNode, readerCfg.getPath(), readerCfg.getType(), readerCfg.getIncludes(), readerCfg.getExcludes(), readerCfg.getParameters());
        } else {
            this.provider.addDefaultReaderConfig(this.chainCfg);
        }
        WalkerConfig walkerCfg = this.chainCfg.getWalkerConfig();
        if (walkerCfg != null) {
            List<TransformationConfig> transformationList;
            String rootNamespace;
            Map<String, Object> wparams;
            ObjectNode walkerNode = null;
            String type = walkerCfg.getType();
            if (type != null) {
                if (chainsNode == null) {
                    chainsNode = new ObjectNode(mapper.getNodeFactory());
                    ObjectNode aux = (ObjectNode)chainsNode;
                    chainsList = new ArrayNode(mapper.getNodeFactory());
                    aux.set("chains", (JsonNode)chainsList);
                }
                walkerNode = new ObjectNode(mapper.getNodeFactory());
                chainNode.set("walker", (JsonNode)walkerNode);
                walkerNode.set("type", (JsonNode)new TextNode(type));
            }
            if ((wparams = walkerCfg.getParams()) != null && !wparams.isEmpty()) {
                if (walkerNode == null) {
                    if (chainsNode == null) {
                        chainsNode = new ObjectNode(mapper.getNodeFactory());
                        ObjectNode aux = (ObjectNode)chainsNode;
                        chainsList = new ArrayNode(mapper.getNodeFactory());
                        aux.set("chains", (JsonNode)chainsList);
                    }
                    walkerNode = new ObjectNode(mapper.getNodeFactory());
                    chainNode.set("walker", (JsonNode)walkerNode);
                }
                this.populateParams(walkerNode, wparams);
            }
            if ((rootNamespace = walkerCfg.getRootNamespace()) != null) {
                if (walkerNode == null) {
                    if (chainsNode == null) {
                        chainsNode = new ObjectNode(mapper.getNodeFactory());
                        ObjectNode aux = (ObjectNode)chainsNode;
                        chainsList = new ArrayNode(mapper.getNodeFactory());
                        aux.set("chains", (JsonNode)chainsList);
                    }
                    walkerNode = new ObjectNode(mapper.getNodeFactory());
                    chainNode.set("walker", (JsonNode)walkerNode);
                }
                walkerNode.set("root-namespace", (JsonNode)new TextNode(rootNamespace));
            }
            if ((transformationList = walkerCfg.getTransformations()) != null && !transformationList.isEmpty()) {
                ArrayNode transformationListNode = new ArrayNode(mapper.getNodeFactory());
                if (walkerNode == null) {
                    if (chainsNode == null) {
                        ObjectNode aux = new ObjectNode(mapper.getNodeFactory());
                        aux.set("transformations", (JsonNode)transformationListNode);
                        chainsNode = aux;
                    } else {
                        chainNode.set("transformations", (JsonNode)transformationListNode);
                    }
                } else {
                    walkerNode.set("transformations", (JsonNode)transformationListNode);
                }
                for (TransformationConfig transCfg : transformationList) {
                    ObjectNode transformationNode = new ObjectNode(mapper.getNodeFactory());
                    transformationListNode.add((JsonNode)transformationNode);
                    this.createTransformation(transformationNode, transCfg);
                }
            }
        }
        if ((writerCfg = this.chainCfg.getWriterConfig()) != null) {
            if (chainsNode == null) {
                chainsNode = new ObjectNode(mapper.getNodeFactory());
                ObjectNode aux = (ObjectNode)chainsNode;
                chainsList = new ArrayNode(mapper.getNodeFactory());
                aux.set("chains", (JsonNode)chainsList);
            }
            ObjectNode writerNode = new ObjectNode(mapper.getNodeFactory());
            chainNode.set("writer", (JsonNode)writerNode);
            this.populateWriterReader(writerNode, writerCfg.getPath(), writerCfg.getType(), writerCfg.getIncludes(), writerCfg.getExcludes(), writerCfg.getParams());
        } else {
            this.provider.addDefaultWriterConfig(this.chainCfg);
        }
        if (chainsList != null) {
            int beforePos = -1;
            if (this.before != null) {
                Iterator it = chainsList.iterator();
                int i = 0;
                while (it.hasNext() && beforePos == -1) {
                    JsonNode next = (JsonNode)it.next();
                    if (next.get("name").equals((Object)this.before)) {
                        beforePos = i;
                    }
                    ++i;
                }
            }
            if (beforePos == -1) {
                chainsList.add((JsonNode)chainNode);
            } else {
                chainsList.insert(beforePos, (JsonNode)chainNode);
            }
        }
        if (readerCfg == null && walkerCfg == null && writerCfg == null) return;
        this.provider.write(chainsNode);
    }

    @Override
    public AbstractYMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new AddChainYMLAction(this.chainCfg, (YAMLConfigurationProvider)provider, recursive, this.before);
    }
}

