/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.xml;

import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.providers.XMLConfigurationProvider;
import org.walkmod.conf.providers.xml.AbstractXMLConfigurationAction;

public class SetWriterXMLAction
extends AbstractXMLConfigurationAction {
    private String chain;
    private String type;
    private String path;
    private Map<String, String> params;

    public SetWriterXMLAction(String chain, String type, String path, XMLConfigurationProvider provider, boolean recursive, Map<String, String> params) {
        super(provider, recursive);
        this.chain = chain;
        this.type = type;
        this.path = path;
        this.params = params;
    }

    @Override
    public void doAction() throws Exception {
        Document document = this.provider.getDocument();
        Element rootElement = document.getDocumentElement();
        Node writerParent = null;
        NodeList children = rootElement.getChildNodes();
        int childSize = children.getLength();
        Element writerElem = null;
        Element child = null;
        for (int i = 0; i < childSize; ++i) {
            Node childNode = children.item(i);
            if (!(childNode instanceof Element)) continue;
            child = (Element)childNode;
            String nodeName = child.getNodeName();
            if ("chain".equals(nodeName)) {
                String name;
                if (!child.hasAttribute("name") || !(name = child.getAttribute("name")).equals(this.chain)) continue;
                writerParent = child;
                continue;
            }
            if (!"transformation".equals(nodeName) || this.chain != null && !"default".equals(this.chain)) continue;
            writerParent = rootElement;
        }
        if (writerParent == rootElement) {
            Element chainElem = document.createElement("chain");
            rootElement.appendChild(chainElem);
            chainElem.setAttribute("name", "default");
            LinkedList<Node> tranformationsToRemove = new LinkedList<Node>();
            for (int i = 0; i < childSize; ++i) {
                Node currentChild = children.item(i);
                if (!currentChild.getNodeName().equals("transformation")) continue;
                tranformationsToRemove.add(currentChild);
            }
            for (Node current : tranformationsToRemove) {
                rootElement.removeChild(current);
            }
            for (Node trsnfNode : tranformationsToRemove) {
                chainElem.appendChild(trsnfNode);
            }
            writerParent = chainElem;
        }
        if (writerParent != null) {
            NodeList siblings = writerParent.getChildNodes();
            int limit = siblings.getLength();
            boolean updated = false;
            for (int i = 0; i < limit && !updated; ++i) {
                Element aux;
                Node childNode = siblings.item(i);
                if (!(childNode instanceof Element) || !"writer".equals((aux = (Element)childNode).getNodeName())) continue;
                if (this.type != null && !"".equals(this.type.trim())) {
                    aux.setAttribute("type", this.type);
                    NodeList childAux = aux.getChildNodes();
                    for (int k = 0; k < childAux.getLength(); ++k) {
                        Element current = (Element)childAux.item(k);
                        if (current == null || !current.getNodeName().equals("param")) continue;
                        aux.removeChild(current);
                        --i;
                    }
                }
                if (this.path != null && !"".equals(this.path.trim())) {
                    aux.setAttribute("path", this.path);
                }
                writerElem = aux;
                updated = true;
            }
            if (!updated) {
                writerElem = document.createElement("writer");
                if (this.type != null && !"".equals(this.type.trim())) {
                    writerElem.setAttribute("type", this.type);
                }
                if (this.path != null && !"".equals(this.path.trim())) {
                    writerElem.setAttribute("path", this.path);
                } else {
                    writerElem.setAttribute("path", "src/main/java");
                }
                writerParent.appendChild(writerElem);
            }
            if (this.params != null && !this.params.isEmpty() && writerElem != null) {
                NodeList childrenWriter = writerElem.getChildNodes();
                int limitChildren = childrenWriter.getLength();
                Element previousElem = null;
                for (int i = 0; i < limitChildren; ++i) {
                    Node childWriter = childrenWriter.item(i);
                    if (childWriter.getNodeName().equals("param")) {
                        Element param = (Element)childWriter;
                        if (!this.params.containsKey(param.getAttribute("name"))) continue;
                        param.setTextContent(this.params.get(param.getAttribute("name")).toString());
                        this.params.remove(param.getAttribute("name"));
                        continue;
                    }
                    if (previousElem != null) continue;
                    previousElem = (Element)childWriter;
                }
                Set<String> keys = this.params.keySet();
                for (String key : keys) {
                    Element elem = document.createElement("param");
                    elem.setAttribute("name", key);
                    elem.setTextContent(this.params.get(key).toString());
                    if (previousElem == null) {
                        writerElem.appendChild(elem);
                        continue;
                    }
                    writerElem.insertBefore(elem, previousElem);
                    previousElem = elem;
                }
            }
            this.provider.persist();
        }
    }

    @Override
    public AbstractXMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new SetWriterXMLAction(this.chain, this.type, this.path, (XMLConfigurationProvider)provider, recursive, this.params);
    }
}

