/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.xml;

import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.providers.XMLConfigurationProvider;
import org.walkmod.conf.providers.xml.AbstractXMLConfigurationAction;

public class SetReaderXMLAction
extends AbstractXMLConfigurationAction {
    private String chain;
    private String type;
    private String path;
    private Map<String, String> params;

    public SetReaderXMLAction(String chain, String type, String path, XMLConfigurationProvider provider, boolean recursive, Map<String, String> params) {
        super(provider, recursive);
        this.chain = chain;
        this.type = type;
        this.path = path;
        this.params = params;
    }

    @Override
    public void doAction() throws Exception {
        Document document = this.provider.getDocument();
        Element rootElement = document.getDocumentElement();
        Node readerParent = null;
        NodeList children = rootElement.getChildNodes();
        int childSize = children.getLength();
        LinkedList<Node> transformationsToRemove = new LinkedList<Node>();
        Element child = null;
        Element readerElement = null;
        for (int i = 0; i < childSize; ++i) {
            Node childNode = children.item(i);
            if (!(childNode instanceof Element)) continue;
            child = (Element)childNode;
            String nodeName = child.getNodeName();
            if ("chain".equals(nodeName)) {
                String name;
                if (!child.hasAttribute("name") || !(name = child.getAttribute("name")).equals(this.chain)) continue;
                readerParent = child;
                continue;
            }
            if (!"transformation".equals(nodeName) || this.chain != null && !"default".equals(this.chain)) continue;
            readerParent = rootElement;
            transformationsToRemove.add(childNode);
        }
        if (readerParent == rootElement) {
            for (Node current : transformationsToRemove) {
                rootElement.removeChild(current);
            }
            Element chainElem = document.createElement("chain");
            chainElem.setAttribute("name", "default");
            rootElement.appendChild(chainElem);
            for (Node current : transformationsToRemove) {
                chainElem.appendChild(current.cloneNode(true));
            }
            readerParent = chainElem;
        }
        if (readerParent != null) {
            NodeList siblings = readerParent.getChildNodes();
            int limit = siblings.getLength();
            boolean updated = false;
            for (int i = 0; i < limit && !updated; ++i) {
                Element aux;
                Node childNode = siblings.item(i);
                if (!(childNode instanceof Element) || !"reader".equals((aux = (Element)childNode).getNodeName())) continue;
                readerElement = aux;
                if (this.type != null && !"".equals(this.type.trim())) {
                    aux.setAttribute("type", this.type);
                }
                if (this.path != null && !"".equals(this.path.trim())) {
                    aux.setAttribute("path", this.path);
                }
                updated = true;
            }
            if (!updated) {
                readerElement = document.createElement("reader");
                if (this.type != null && !"".equals(this.type.trim())) {
                    readerElement.setAttribute("type", this.type);
                }
                if (this.path != null && !"".equals(this.path.trim())) {
                    readerElement.setAttribute("path", this.path);
                } else {
                    readerElement.setAttribute("path", "src/main/java");
                }
                readerParent.insertBefore(readerElement, readerParent.getFirstChild());
            }
            if (this.params != null && !this.params.isEmpty() && readerElement != null) {
                NodeList childrenWriter = readerElement.getChildNodes();
                int limitChildren = childrenWriter.getLength();
                Element previousElem = null;
                for (int i = 0; i < limitChildren; ++i) {
                    Node childWriter = childrenWriter.item(i);
                    if (childWriter.getNodeName().equals("param")) {
                        Element param = (Element)childWriter;
                        if (!this.params.containsKey(param.getAttribute("name"))) continue;
                        param.setTextContent(this.params.get(param.getAttribute("name")).toString());
                        this.params.remove(param.getAttribute("name"));
                        continue;
                    }
                    if (previousElem != null) continue;
                    previousElem = (Element)childWriter;
                }
                Set<String> keys = this.params.keySet();
                for (String key : keys) {
                    Element elem = document.createElement("param");
                    elem.setAttribute("name", key);
                    elem.setTextContent(this.params.get(key).toString());
                    if (previousElem == null) {
                        readerElement.appendChild(elem);
                        continue;
                    }
                    readerElement.insertBefore(elem, previousElem);
                    previousElem = elem;
                }
            }
            this.provider.persist();
        }
    }

    @Override
    public AbstractXMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new SetReaderXMLAction(this.chain, this.type, this.path, (XMLConfigurationProvider)provider, recursive, this.params);
    }
}

