/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.xml;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.PluginConfig;
import org.walkmod.conf.providers.XMLConfigurationProvider;
import org.walkmod.conf.providers.xml.AbstractXMLConfigurationAction;

public class RemovePluginXMLAction
extends AbstractXMLConfigurationAction {
    private PluginConfig pluginConfig;

    public RemovePluginXMLAction(PluginConfig pluginConfig, XMLConfigurationProvider provider, boolean recursive) {
        super(provider, recursive);
        this.pluginConfig = pluginConfig;
    }

    @Override
    public void doAction() throws Exception {
        Document document = this.provider.getDocument();
        Element rootElement = document.getDocumentElement();
        NodeList children = rootElement.getChildNodes();
        int childSize = children.getLength();
        for (int i = 0; i < childSize; ++i) {
            Element child;
            String nodeName;
            Node childNode = children.item(i);
            if (!(childNode instanceof Element) || !"plugins".equals(nodeName = (child = (Element)childNode).getNodeName())) continue;
            NodeList pluginNodes = child.getChildNodes();
            int modulesSize = pluginNodes.getLength();
            for (int j = 0; j < modulesSize; ++j) {
                Node pluginNode = pluginNodes.item(j);
                if (!"plugin".equals(pluginNode.getNodeName())) continue;
                Element aux = (Element)pluginNode;
                String groupId = aux.getAttribute("groupId");
                String artifactId = aux.getAttribute("artifactId");
                if (!groupId.equals(this.pluginConfig.getGroupId()) || !artifactId.equals(this.pluginConfig.getArtifactId())) continue;
                child.removeChild(aux);
                this.provider.persist();
                return;
            }
        }
    }

    @Override
    public AbstractXMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new RemovePluginXMLAction(this.pluginConfig, (XMLConfigurationProvider)provider, recursive);
    }
}

