/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.xml;

import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.providers.XMLConfigurationProvider;
import org.walkmod.conf.providers.xml.AbstractXMLConfigurationAction;

public class RemoveModulesXMLAction
extends AbstractXMLConfigurationAction {
    private List<String> modules;

    public RemoveModulesXMLAction(List<String> modules, XMLConfigurationProvider provider) {
        super(provider, false);
        this.modules = modules;
    }

    @Override
    public void doAction() throws Exception {
        Document document = this.provider.getDocument();
        Element rootElement = document.getDocumentElement();
        NodeList children = rootElement.getChildNodes();
        int childSize = children.getLength();
        Element child = null;
        int removed = 0;
        for (int i = 0; i < childSize; ++i) {
            String nodeName;
            Node childNode = children.item(i);
            if (!(childNode instanceof Element) || !"modules".equals(nodeName = (child = (Element)childNode).getNodeName())) continue;
            NodeList moduleNodeList = child.getChildNodes();
            int max = moduleNodeList.getLength();
            for (int j = 0; j < max; ++j) {
                String value = moduleNodeList.item(j).getTextContent().trim();
                if (!this.modules.contains(value)) continue;
                child.removeChild(moduleNodeList.item(j));
                ++removed;
            }
            if (removed != max) continue;
            rootElement.removeChild(child);
        }
        if (removed > 0) {
            this.provider.persist();
        }
    }

    @Override
    public AbstractXMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new RemoveModulesXMLAction(this.modules, (XMLConfigurationProvider)provider);
    }
}

