/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.xml;

import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.providers.XMLConfigurationProvider;
import org.walkmod.conf.providers.xml.AbstractXMLConfigurationAction;

public class RemoveIncludesOrExcludesXMLAction
extends AbstractXMLConfigurationAction {
    private List<String> includes;
    private String chain;
    private boolean setToReader;
    private boolean setToWriter;
    private boolean isExcludes;

    public RemoveIncludesOrExcludesXMLAction(List<String> includes, String chain, boolean recursive, boolean setToReader, boolean setToWriter, boolean isExcludes, XMLConfigurationProvider provider) {
        super(provider, recursive);
        this.includes = includes;
        this.chain = chain;
        this.setToReader = setToReader;
        this.setToWriter = setToWriter;
    }

    @Override
    public void doAction() throws Exception {
        Document document = this.provider.getDocument();
        Element rootElement = document.getDocumentElement();
        NodeList children = rootElement.getChildNodes();
        int childSize = children.getLength();
        if (this.chain == null) {
            this.chain = "default";
        }
        boolean updated = false;
        for (int i = 0; i < childSize; ++i) {
            String name;
            Element child;
            String nodeName;
            Node childNode = children.item(i);
            if (!(childNode instanceof Element) || !"chain".equals(nodeName = (child = (Element)childNode).getNodeName()) || !(name = child.getAttribute("name")).equals(this.chain)) continue;
            NodeList chainChildren = child.getChildNodes();
            int chainChildrenSize = chainChildren.getLength();
            for (int j = 0; j < chainChildrenSize; ++j) {
                Node chainChild = chainChildren.item(j);
                if (!(chainChild instanceof Element)) continue;
                Element elementChain = (Element)chainChild;
                String elementName = elementChain.getNodeName();
                if (elementName.equals("reader") && this.setToReader) {
                    this.updateElement(elementChain);
                    updated = true;
                    continue;
                }
                if (!elementName.equals("writer") || !this.setToWriter) continue;
                this.updateElement(elementChain);
                updated = true;
            }
        }
        if (updated) {
            this.provider.persist();
        }
    }

    private void updateElement(Element elementChain) {
        String label = "include";
        if (this.isExcludes) {
            label = "exclude";
        }
        NodeList childNodes = elementChain.getChildNodes();
        int limit = childNodes.getLength();
        for (int i = 0; i < limit; ++i) {
            Element aux;
            String value;
            Node childNode = childNodes.item(i);
            if (!childNode.getNodeName().equals(label) || !this.includes.contains(value = (aux = (Element)childNode).getAttribute("wildcard"))) continue;
            elementChain.removeChild(childNode);
        }
    }

    @Override
    public AbstractXMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new RemoveIncludesOrExcludesXMLAction(this.includes, this.chain, recursive, this.setToReader, this.setToWriter, this.isExcludes, (XMLConfigurationProvider)provider);
    }
}

