/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.xml;

import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.providers.XMLConfigurationProvider;
import org.walkmod.conf.providers.xml.AbstractXMLConfigurationAction;

public class RemoveChainsXMLAction
extends AbstractXMLConfigurationAction {
    private List<String> chains;

    public RemoveChainsXMLAction(List<String> chains, XMLConfigurationProvider provider, boolean recursive) {
        super(provider, recursive);
        this.chains = chains;
    }

    @Override
    public void doAction() throws Exception {
        Document document = this.provider.getDocument();
        HashSet<String> aux = new HashSet<String>(this.chains);
        Element rootElement = document.getDocumentElement();
        NodeList children = rootElement.getChildNodes();
        int childSize = children.getLength();
        Element child = null;
        int removed = 0;
        for (int i = 0; i < childSize; ++i) {
            Node childNode = children.item(i);
            if (!(childNode instanceof Element)) continue;
            child = (Element)childNode;
            String nodeName = child.getNodeName();
            if ("chain".equals(nodeName)) {
                if (!aux.contains(child.getAttribute("name"))) continue;
                rootElement.removeChild(childNode);
                ++removed;
                continue;
            }
            if (!"transformation".equals(nodeName) || !aux.contains("default")) continue;
            rootElement.removeChild(childNode);
            ++removed;
        }
        if (removed > 0) {
            this.provider.persist();
        }
    }

    @Override
    public AbstractXMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new RemoveChainsXMLAction(this.chains, (XMLConfigurationProvider)provider, recursive);
    }
}

