/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.xml;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.ChainConfig;
import org.walkmod.conf.entities.TransformationConfig;
import org.walkmod.conf.entities.WalkerConfig;
import org.walkmod.conf.entities.impl.ChainConfigImpl;
import org.walkmod.conf.entities.impl.ConfigurationImpl;
import org.walkmod.conf.providers.XMLConfigurationProvider;
import org.walkmod.conf.providers.xml.AbstractXMLConfigurationAction;

public class AddTransformationXMLAction
extends AbstractXMLConfigurationAction {
    private String chain;
    private String path;
    private TransformationConfig transformationCfg;
    private Integer order;
    private String before;

    public AddTransformationXMLAction(String chain, String path, TransformationConfig transformationCfg, XMLConfigurationProvider provider, boolean recursive, Integer order, String before) {
        super(provider, recursive);
        this.chain = chain;
        this.path = path;
        this.transformationCfg = transformationCfg;
        this.order = order;
        this.before = before;
    }

    @Override
    public void doAction() throws Exception {
        Document document = this.provider.getDocument();
        Element rootElement = document.getDocumentElement();
        NodeList children = rootElement.getChildNodes();
        int childSize = children.getLength();
        if (this.chain == null || "".equals(this.chain)) {
            this.chain = "default";
        }
        Element beforeChain = null;
        if (!"default".equals(this.chain)) {
            boolean appended = false;
            boolean isTransformationList = false;
            for (int i = 0; i < childSize && !isTransformationList && !appended; ++i) {
                Node childNode = children.item(i);
                if (!(childNode instanceof Element)) continue;
                Element child = (Element)childNode;
                String nodeName = child.getNodeName();
                if ("chain".equals(nodeName)) {
                    String name = child.getAttribute("name");
                    if (this.before != null && name.equals(this.before)) {
                        beforeChain = child;
                    }
                    if (!name.equals(this.chain)) continue;
                    Element transfElement = this.createTransformationElement(this.transformationCfg);
                    NodeList innerChainNodes = child.getChildNodes();
                    int maxK = innerChainNodes.getLength();
                    boolean added = false;
                    boolean hasWalker = false;
                    for (int k = 0; k < maxK && !added; ++k) {
                        Element chainInnerElem = (Element)innerChainNodes.item(k);
                        boolean bl = hasWalker = hasWalker || chainInnerElem.getNodeName().equals("walker");
                        if (hasWalker) {
                            int maxj;
                            NodeList transfList = chainInnerElem.getChildNodes();
                            for (int j = maxj = transfList.getLength(); j >= 0 && !added; --j) {
                                if (!transfList.item(j).getNodeName().equals("transformations") || this.order != null && this.order != j) continue;
                                transfList.item(j).appendChild(transfElement);
                                added = true;
                            }
                            continue;
                        }
                        if (!chainInnerElem.getNodeName().equals("writer")) continue;
                        child.insertBefore(transfElement, chainInnerElem);
                        added = true;
                    }
                    if (!added) {
                        child.appendChild(transfElement);
                    }
                    appended = true;
                    continue;
                }
                if (!"transformation".equals(nodeName)) continue;
                isTransformationList = true;
            }
            Element defaultChainElement = null;
            if (isTransformationList) {
                ConfigurationImpl configuration = new ConfigurationImpl();
                this.provider.setConfiguration(configuration);
                this.provider.loadChains();
                Collection<ChainConfig> chainCfgs = configuration.getChainConfigs();
                ChainConfig chainCfg = chainCfgs.iterator().next();
                NodeList child = rootElement.getChildNodes();
                int limit = child.getLength();
                for (int i = 0; i < limit; ++i) {
                    Element auxElem;
                    Node item = child.item(i);
                    if (!(item instanceof Element) || !(auxElem = (Element)item).getNodeName().equals("transformation")) continue;
                    rootElement.removeChild(auxElem);
                    --i;
                }
                defaultChainElement = this.createChainElement(chainCfg);
            }
            if (!appended) {
                ChainConfigImpl chainCfg = new ChainConfigImpl();
                chainCfg.setName(this.chain);
                this.provider.addDefaultReaderConfig(chainCfg);
                this.provider.addDefaultWriterConfig(chainCfg);
                if (this.path != null && !"".equals(this.path.trim())) {
                    chainCfg.getReaderConfig().setPath(this.path);
                    chainCfg.getWriterConfig().setPath(this.path);
                }
                this.provider.addDefaultWalker(chainCfg);
                WalkerConfig walkerCfg = chainCfg.getWalkerConfig();
                LinkedList<TransformationConfig> transfs = new LinkedList<TransformationConfig>();
                transfs.add(this.transformationCfg);
                walkerCfg.setTransformations(transfs);
                chainCfg.setWalkerConfig(walkerCfg);
                if (beforeChain != null) {
                    rootElement.insertBefore(this.createChainElement(chainCfg), beforeChain);
                } else {
                    if (this.before == null && defaultChainElement != null) {
                        rootElement.appendChild(defaultChainElement);
                    }
                    rootElement.appendChild(this.createChainElement(chainCfg));
                    if ("default".equals(this.before) && defaultChainElement != null) {
                        rootElement.appendChild(defaultChainElement);
                    }
                }
            }
            this.provider.persist();
        } else {
            Element chainNode = null;
            boolean containsChains = false;
            for (int i = 0; i < childSize && chainNode == null; ++i) {
                Node childNode = children.item(i);
                if (!(childNode instanceof Element)) continue;
                Element auxNode = (Element)childNode;
                String nodeName = auxNode.getNodeName();
                containsChains = "chain".equals(nodeName);
                if (!auxNode.getAttribute("name").equals(this.chain)) continue;
                chainNode = auxNode;
            }
            if (containsChains) {
                if (chainNode != null) {
                    String attrName = chainNode.getAttribute("name");
                    if (attrName == null || attrName.equals("") || attrName.equals("default")) {
                        NodeList chainChildren = chainNode.getChildNodes();
                        if (this.path != null && !"".equals(this.path.trim())) {
                            for (int i = 0; i < chainChildren.getLength(); ++i) {
                                Element aux;
                                Node childNode = chainChildren.item(i);
                                String nodeType = childNode.getNodeName();
                                if (!nodeType.equals("reader") || (aux = (Element)childNode).getAttribute("path").equals(this.path.trim())) continue;
                                throw new TransformerException("The user must specify a chain name (new or existing) where to add the transformation: [" + this.transformationCfg.getType() + "]");
                            }
                        }
                        if (chainChildren.getLength() > 0) {
                            Node lastElem = chainChildren.item(chainChildren.getLength() - 1);
                            if (lastElem.getNodeName().equals("writer")) {
                                chainNode.insertBefore(this.createTransformationElement(this.transformationCfg), lastElem);
                            }
                            if (lastElem.getNodeName().equals("transformation")) {
                                chainNode.appendChild(this.createTransformationElement(this.transformationCfg));
                            }
                            if (lastElem.getNodeName().equals("walker")) {
                                lastElem.appendChild(this.createTransformationElement(this.transformationCfg));
                            }
                            this.provider.persist();
                            return;
                        }
                    }
                } else {
                    ChainConfigImpl chainCfg = new ChainConfigImpl();
                    chainCfg.setName("default");
                    this.provider.addDefaultReaderConfig(chainCfg);
                    this.provider.addDefaultWriterConfig(chainCfg);
                    this.provider.addDefaultWalker(chainCfg);
                    WalkerConfig walkerCfg = chainCfg.getWalkerConfig();
                    LinkedList<TransformationConfig> transfs = new LinkedList<TransformationConfig>();
                    transfs.add(this.transformationCfg);
                    walkerCfg.setTransformations(transfs);
                    chainCfg.setWalkerConfig(walkerCfg);
                    rootElement.appendChild(this.createChainElement(chainCfg));
                    this.provider.persist();
                    return;
                }
            }
            if (this.path != null && !"".equals(this.path.trim())) {
                ConfigurationImpl configuration = new ConfigurationImpl();
                this.provider.setConfiguration(configuration);
                this.provider.loadChains();
                Collection<ChainConfig> chainCfgs = configuration.getChainConfigs();
                if (chainCfgs.isEmpty()) {
                    ChainConfigImpl chainCfg = new ChainConfigImpl();
                    chainCfg.setName("default");
                    this.provider.addDefaultReaderConfig(chainCfg);
                    this.provider.addDefaultWriterConfig(chainCfg);
                    if (this.path != null && !"".equals(this.path.trim())) {
                        chainCfg.getReaderConfig().setPath(this.path);
                        chainCfg.getWriterConfig().setPath(this.path);
                    }
                    this.provider.addDefaultWalker(chainCfg);
                    WalkerConfig walkerCfg = chainCfg.getWalkerConfig();
                    LinkedList<TransformationConfig> transfs = new LinkedList<TransformationConfig>();
                    transfs.add(this.transformationCfg);
                    walkerCfg.setTransformations(transfs);
                    chainCfg.setWalkerConfig(walkerCfg);
                    NodeList childrenNodes = rootElement.getChildNodes();
                    int limitChildren = childrenNodes.getLength();
                    for (int i = 0; i < limitChildren; ++i) {
                        rootElement.removeChild(childrenNodes.item(i));
                        --i;
                    }
                    rootElement.appendChild(this.createChainElement(chainCfg));
                    this.provider.persist();
                    return;
                }
                ChainConfig chainCfg = chainCfgs.iterator().next();
                chainCfg.getReaderConfig().setPath(this.path);
                chainCfg.getWriterConfig().setPath(this.path);
                List<TransformationConfig> transfs = chainCfg.getWalkerConfig().getTransformations();
                if (this.order != null && this.order < transfs.size()) {
                    transfs.add(this.order, this.transformationCfg);
                } else {
                    transfs.add(this.transformationCfg);
                }
                document.removeChild(rootElement);
                document.appendChild(this.createChainElement(chainCfg));
                this.provider.persist();
                return;
            }
            rootElement.appendChild(this.createTransformationElement(this.transformationCfg));
            this.provider.persist();
        }
    }

    @Override
    public AddTransformationXMLAction clone(ConfigurationProvider provider, boolean recursive) {
        return new AddTransformationXMLAction(this.chain, this.path, this.transformationCfg, (XMLConfigurationProvider)provider, recursive, this.order, this.before);
    }
}

