/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.xml;

import java.util.Collection;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.ChainConfig;
import org.walkmod.conf.entities.ReaderConfig;
import org.walkmod.conf.entities.WriterConfig;
import org.walkmod.conf.entities.impl.ChainConfigImpl;
import org.walkmod.conf.entities.impl.ConfigurationImpl;
import org.walkmod.conf.providers.XMLConfigurationProvider;
import org.walkmod.conf.providers.xml.AbstractXMLConfigurationAction;

public class AddIncludesOrExcludesXMLAction
extends AbstractXMLConfigurationAction {
    private List<String> includes;
    private String chain;
    private boolean setToReader;
    private boolean setToWriter;
    private boolean isExcludes;

    public AddIncludesOrExcludesXMLAction(List<String> includes, String chain, boolean recursive, boolean setToReader, boolean setToWriter, boolean isExcludes, XMLConfigurationProvider provider) {
        super(provider, recursive);
        this.includes = includes;
        this.setToReader = setToReader;
        this.setToWriter = setToWriter;
        this.chain = chain;
        this.isExcludes = isExcludes;
    }

    private void updateElement(Element element) {
        String label = "include";
        if (this.isExcludes) {
            label = "exclude";
        }
        Document document = this.provider.getDocument();
        String path = element.getAttribute("path");
        int limit = path.length();
        if (!path.endsWith("/")) {
            ++limit;
        }
        for (String include : this.includes) {
            Element includeElem = document.createElement(label);
            if (include.startsWith(path)) {
                include = include.substring(limit);
            }
            includeElem.setAttribute("wildcard", include);
            element.appendChild(includeElem);
        }
    }

    @Override
    public void doAction() throws Exception {
        Document document = this.provider.getDocument();
        Element rootElement = document.getDocumentElement();
        NodeList children = rootElement.getChildNodes();
        int childSize = children.getLength();
        boolean chainFound = false;
        boolean containsChains = false;
        if (this.chain == null) {
            this.chain = "default";
        }
        for (int i = 0; i < childSize; ++i) {
            Node childNode = children.item(i);
            if (!(childNode instanceof Element)) continue;
            Element child = (Element)childNode;
            String nodeName = child.getNodeName();
            String writerPath = "src/main/java";
            if (!"chain".equals(nodeName)) continue;
            containsChains = true;
            String name = child.getAttribute("name");
            if (!name.equals(this.chain)) continue;
            chainFound = true;
            NodeList chainChildren = child.getChildNodes();
            int chainChildrenSize = chainChildren.getLength();
            boolean existsReader = false;
            boolean existsWriter = false;
            for (int j = 0; j < chainChildrenSize; ++j) {
                Node chainChild = chainChildren.item(j);
                if (!(chainChild instanceof Element)) continue;
                Element elementChain = (Element)chainChild;
                String elementName = elementChain.getNodeName();
                if (elementName.equals("reader") && this.setToReader) {
                    existsReader = true;
                    this.updateElement(elementChain);
                    writerPath = elementChain.getAttribute("path");
                    continue;
                }
                if (!elementName.equals("writer") || !this.setToWriter) continue;
                existsWriter = true;
                this.updateElement(elementChain);
            }
            if (!existsReader && this.setToReader) {
                Element reader = document.createElement("reader");
                reader.setAttribute("path", "src/main/java");
                this.updateElement(reader);
                if (chainChildrenSize == 0) {
                    child.appendChild(reader);
                } else {
                    child.insertBefore(reader, chainChildren.item(0));
                }
            }
            if (existsWriter || !this.setToWriter) continue;
            Element writer = document.createElement("writer");
            writer.setAttribute("path", writerPath);
            this.updateElement(writer);
            child.appendChild(writer);
        }
        if (!chainFound) {
            String[] aux;
            ChainConfig chainCfg = null;
            if (!containsChains) {
                ConfigurationImpl configuration = new ConfigurationImpl();
                this.provider.setConfiguration(configuration);
                this.provider.loadChains();
                Collection<ChainConfig> chainCfgs = configuration.getChainConfigs();
                chainCfg = chainCfgs.iterator().next();
                NodeList child = rootElement.getChildNodes();
                int limit = child.getLength();
                for (int i = 0; i < limit; ++i) {
                    Element auxElem;
                    Node item = child.item(i);
                    if (!(item instanceof Element) || !(auxElem = (Element)item).getNodeName().equals("transformation")) continue;
                    rootElement.removeChild(auxElem);
                }
                if (!this.chain.equals("default")) {
                    rootElement.appendChild(this.createChainElement(chainCfg));
                    chainCfg = new ChainConfigImpl();
                    chainCfg.setName(this.chain);
                    this.provider.addDefaultReaderConfig(chainCfg);
                    this.provider.addDefaultWriterConfig(chainCfg);
                    this.provider.addDefaultWalker(chainCfg);
                }
            } else {
                chainCfg = new ChainConfigImpl();
                chainCfg.setName(this.chain);
                this.provider.addDefaultReaderConfig(chainCfg);
                this.provider.addDefaultWriterConfig(chainCfg);
                this.provider.addDefaultWalker(chainCfg);
            }
            if (this.setToReader) {
                ReaderConfig rcfg = chainCfg.getReaderConfig();
                aux = new String[this.includes.size()];
                rcfg.setIncludes(this.includes.toArray(aux));
                chainCfg.setReaderConfig(rcfg);
            }
            if (this.setToWriter) {
                WriterConfig wcfg = chainCfg.getWriterConfig();
                aux = new String[this.includes.size()];
                wcfg.setIncludes(this.includes.toArray(aux));
                chainCfg.setWriterConfig(wcfg);
            }
            rootElement.appendChild(this.createChainElement(chainCfg));
        }
        this.provider.persist();
    }

    @Override
    public AbstractXMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new AddIncludesOrExcludesXMLAction(this.includes, this.chain, recursive, this.setToReader, this.setToWriter, this.isExcludes, (XMLConfigurationProvider)provider);
    }
}

