/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.xml;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.ChainConfig;
import org.walkmod.conf.providers.XMLConfigurationProvider;
import org.walkmod.conf.providers.xml.AbstractXMLConfigurationAction;

public class AddChainXMLAction
extends AbstractXMLConfigurationAction {
    private ChainConfig chainCfg;
    private String before;

    public AddChainXMLAction(ChainConfig chainCfg, XMLConfigurationProvider provider, boolean recursive, String before) {
        super(provider, recursive);
        this.chainCfg = chainCfg;
        this.before = before;
    }

    @Override
    public void doAction() throws Exception {
        Document document = this.provider.getDocument();
        Element rootElement = document.getDocumentElement();
        NodeList children = rootElement.getChildNodes();
        int childSize = children.getLength();
        Element beforeElement = null;
        if (this.chainCfg.getName() != null && !"".equals(this.chainCfg.getName())) {
            for (int i = 0; i < childSize; ++i) {
                Element child;
                String nodeName;
                Node childNode = children.item(i);
                if (!(childNode instanceof Element) || !"chain".equals(nodeName = (child = (Element)childNode).getNodeName())) continue;
                String name = child.getAttribute("name");
                if (name.equals(this.chainCfg.getName())) {
                    return;
                }
                if (this.before == null || !name.equals(this.before)) continue;
                beforeElement = child;
            }
        }
        if (beforeElement == null) {
            rootElement.appendChild(this.createChainElement(this.chainCfg));
        } else {
            rootElement.insertBefore(this.createChainElement(this.chainCfg), beforeElement);
        }
        this.provider.persist();
    }

    @Override
    public AbstractXMLConfigurationAction clone(ConfigurationProvider provider, boolean recursive) {
        return new AddChainXMLAction(this.chainCfg, (XMLConfigurationProvider)provider, recursive, this.before);
    }
}

