/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers.xml;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.ChainConfig;
import org.walkmod.conf.entities.ReaderConfig;
import org.walkmod.conf.entities.TransformationConfig;
import org.walkmod.conf.entities.WalkerConfig;
import org.walkmod.conf.entities.WriterConfig;
import org.walkmod.conf.entities.impl.ConfigurationImpl;
import org.walkmod.conf.providers.ConfigurationAction;
import org.walkmod.conf.providers.XMLConfigurationProvider;

public abstract class AbstractXMLConfigurationAction
implements ConfigurationAction {
    protected XMLConfigurationProvider provider;
    private boolean recursive = false;

    public AbstractXMLConfigurationAction(XMLConfigurationProvider provider, boolean recursive) {
        this.provider = provider;
        this.recursive = recursive;
    }

    @Override
    public void execute() throws Exception {
        File file = new File(this.provider.getConfigFileName());
        if (!file.exists()) {
            this.provider.createConfig();
            this.provider.init(new ConfigurationImpl());
        } else {
            this.provider.init(new ConfigurationImpl());
        }
        if (this.recursive) {
            Document document = this.provider.getDocument();
            Element rootElement = document.getDocumentElement();
            NodeList children = rootElement.getChildNodes();
            int childSize = children.getLength();
            boolean containsModules = false;
            for (int i = 0; i < childSize; ++i) {
                Element child;
                String nodeName;
                Node childNode = children.item(i);
                if (!(childNode instanceof Element) || !"modules".equals(nodeName = (child = (Element)childNode).getNodeName())) continue;
                containsModules = true;
                NodeList moduleNodeList = child.getChildNodes();
                int max = moduleNodeList.getLength();
                for (int j = 0; j < max; ++j) {
                    String cfg = this.provider.getConfigFileName();
                    if (cfg == null) continue;
                    File auxFile = new File(cfg).getCanonicalFile().getParentFile();
                    File moduleFileDir = new File(auxFile, moduleNodeList.item(j).getTextContent());
                    XMLConfigurationProvider aux = new XMLConfigurationProvider(moduleFileDir.getAbsolutePath() + File.separator + "walkmod.xml", false);
                    AbstractXMLConfigurationAction ct = this.clone(aux, this.recursive);
                    ct.execute();
                }
            }
            if (!containsModules) {
                this.doAction();
            }
        } else {
            this.doAction();
        }
    }

    public abstract void doAction() throws Exception;

    public List<Element> createParamsElement(Map<String, Object> params) {
        LinkedList<Element> result = null;
        if (params != null && !params.isEmpty()) {
            Document document = this.provider.getDocument();
            result = new LinkedList<Element>();
            Set<String> paramLabels = params.keySet();
            for (String label : paramLabels) {
                Element param = document.createElement("param");
                param.setAttribute("name", label);
                param.setTextContent(params.get(label).toString());
                result.add(param);
            }
        }
        return result;
    }

    public void createReaderOrWriterContent(Element root, String path, String type, Map<String, Object> params, String[] includes, String[] excludes) {
        List<Element> list;
        List<Element> includeElementList;
        List<Element> paramListEment;
        if (path == null || "".equals(path)) {
            path = "src/main/java";
        }
        root.setAttribute("path", path);
        if (type != null && !"".equals(type)) {
            root.setAttribute("type", type);
        }
        if ((paramListEment = this.createParamsElement(params)) != null) {
            for (Element element : paramListEment) {
                root.appendChild(element);
            }
        }
        if ((includeElementList = this.createIncludeList(includes, path)) != null) {
            for (Element includeElement : includeElementList) {
                root.appendChild(includeElement);
            }
        }
        if ((list = this.createExcludeList(excludes, path)) != null) {
            for (Element excludeElement : list) {
                root.appendChild(excludeElement);
            }
        }
    }

    public List<Element> createIncludeList(String[] includes, String path) {
        LinkedList<Element> result = null;
        if (includes != null) {
            result = new LinkedList<Element>();
            Document document = this.provider.getDocument();
            int limit = path.length();
            if (!path.endsWith("/")) {
                ++limit;
            }
            for (String include : includes) {
                Element includeElem = document.createElement("include");
                if (include.startsWith(path)) {
                    include = include.substring(limit);
                }
                includeElem.setAttribute("wildcard", include);
                result.add(includeElem);
            }
        }
        return result;
    }

    public List<Element> createExcludeList(String[] excludes, String path) {
        LinkedList<Element> result = null;
        if (excludes != null) {
            result = new LinkedList<Element>();
            Document document = this.provider.getDocument();
            int limit = path.length();
            if (!path.endsWith("/")) {
                ++limit;
            }
            for (String exclude : excludes) {
                Element excludeElem = document.createElement("exclude");
                if (exclude.startsWith(path)) {
                    exclude = exclude.substring(limit);
                }
                excludeElem.setAttribute("wildcard", exclude);
                result.add(excludeElem);
            }
        }
        return result;
    }

    private List<Element> createTransformationList(List<TransformationConfig> transformations) {
        LinkedList<Element> result = null;
        if (transformations != null) {
            result = new LinkedList<Element>();
            Document document = this.provider.getDocument();
            for (TransformationConfig tcfg : transformations) {
                Map<String, Object> params;
                List<Element> paramListEment;
                Element trans = document.createElement("transformation");
                String name = tcfg.getName();
                if (name != null) {
                    trans.setAttribute("name", name);
                }
                trans.setAttribute("type", tcfg.getType());
                String mergePolicy = tcfg.getMergePolicy();
                if (mergePolicy != null) {
                    trans.setAttribute("merge-policy", mergePolicy);
                }
                if (tcfg.isMergeable()) {
                    trans.setAttribute("isMergeable", "true");
                }
                if ((paramListEment = this.createParamsElement(params = tcfg.getParameters())) != null) {
                    for (Element param : paramListEment) {
                        trans.appendChild(param);
                    }
                }
                result.add(trans);
            }
        }
        return result;
    }

    public Element createTransformationElement(TransformationConfig transformationCfg) {
        Map<String, Object> params;
        List<Element> paramListEment;
        String mergePolicy;
        String type;
        Document document = this.provider.getDocument();
        Element element = document.createElement("transformation");
        String name = transformationCfg.getName();
        if (name != null && !"".equals(name)) {
            element.setAttribute("name", transformationCfg.getName());
        }
        if ((type = transformationCfg.getType()) != null && !"".equals(type)) {
            element.setAttribute("type", type);
        }
        if ((mergePolicy = transformationCfg.getMergePolicy()) != null && !"".equals(mergePolicy)) {
            element.setAttribute("merge-policy", mergePolicy);
        }
        if (transformationCfg.isMergeable()) {
            element.setAttribute("isMergeable", "true");
        }
        if ((paramListEment = this.createParamsElement(params = transformationCfg.getParameters())) != null) {
            for (Element param : paramListEment) {
                element.appendChild(param);
            }
        }
        return element;
    }

    public Element createChainElement(ChainConfig chainCfg) {
        WriterConfig writerConfig;
        WalkerConfig wConfig;
        ReaderConfig rConfig;
        Document document = this.provider.getDocument();
        Element element = document.createElement("chain");
        String name = chainCfg.getName();
        if (name != null && !"".equals(name)) {
            element.setAttribute("name", chainCfg.getName());
        }
        if ((rConfig = chainCfg.getReaderConfig()) != null && (rConfig.getType() != null || rConfig.getPath() != null || rConfig.getIncludes() != null || rConfig.getExcludes() != null || rConfig.getParameters() != null)) {
            Element reader = document.createElement("reader");
            this.createReaderOrWriterContent(reader, rConfig.getPath(), rConfig.getType(), rConfig.getParameters(), rConfig.getIncludes(), rConfig.getExcludes());
            element.appendChild(reader);
        }
        if ((wConfig = chainCfg.getWalkerConfig()) != null) {
            Map<String, Object> params = wConfig.getParams();
            List<Element> result = this.createTransformationList(wConfig.getTransformations());
            if (params == null && (wConfig.getType() == null || "".equals(wConfig.getType()))) {
                if (result != null) {
                    for (Element transformationElement : result) {
                        element.appendChild(transformationElement);
                    }
                }
            } else {
                List<Element> paramListEment;
                Element walker = document.createElement("walker");
                String type = wConfig.getType();
                if (type != null && !"".equals(type)) {
                    walker.setAttribute("type", type);
                }
                if ((paramListEment = this.createParamsElement(params)) != null) {
                    for (Element param : paramListEment) {
                        walker.appendChild(param);
                    }
                }
                Element transformationList = document.createElement("transformations");
                if (result != null) {
                    for (Element transformationElement : result) {
                        transformationList.appendChild(transformationElement);
                    }
                }
                walker.appendChild(transformationList);
                element.appendChild(walker);
            }
        }
        if ((writerConfig = chainCfg.getWriterConfig()) != null && (writerConfig.getType() != null || writerConfig.getPath() != null || writerConfig.getExcludes() != null || writerConfig.getIncludes() != null || writerConfig.getParams() != null)) {
            Element writer = document.createElement("writer");
            this.createReaderOrWriterContent(writer, writerConfig.getPath(), writerConfig.getType(), writerConfig.getParams(), writerConfig.getIncludes(), writerConfig.getExcludes());
            element.appendChild(writer);
        }
        return element;
    }

    public abstract AbstractXMLConfigurationAction clone(ConfigurationProvider var1, boolean var2);
}

