/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.providers;

import org.apache.commons.lang.StringUtils;
import org.walkmod.Options;
import org.walkmod.conf.ConfigurationException;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.entities.ChainConfig;
import org.walkmod.conf.entities.Configuration;
import org.walkmod.conf.entities.impl.ChainConfigImpl;
import org.walkmod.conf.entities.impl.TransformationConfigImpl;

public class DynamicConfigurationProvider
implements ConfigurationProvider {
    private Configuration configuration;
    private Options options;
    private String[] chains;

    public DynamicConfigurationProvider(Options options, String ... chains) {
        this.options = options;
        this.chains = chains;
    }

    @Override
    public void init(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void load() throws ConfigurationException {
        String path = this.options.getPath();
        this.configuration.prepareInitializers();
        if (this.chains != null) {
            for (String chain : this.chains) {
                ChainConfig cc;
                if (!StringUtils.isNotEmpty((String)chain) || (cc = this.configuration.getChainConfig(chain)) != null) continue;
                cc = new ChainConfigImpl(new TransformationConfigImpl(chain));
                this.configuration.addChainConfig(cc);
            }
            this.configuration.preparePlugins();
        }
        if (StringUtils.isNotEmpty((String)path)) {
            for (ChainConfig cc : this.configuration.getChainConfigs()) {
                cc.setPath(path);
            }
        }
    }
}

