/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.entities.impl;

import org.walkmod.conf.entities.PluginConfig;

public class PluginConfigImpl
implements PluginConfig {
    private String groupId;
    private String artifactId;
    private String version;

    public PluginConfigImpl() {
    }

    public PluginConfigImpl(String plugin) {
        String[] parts = plugin.split(":");
        boolean valid = parts.length <= 3;
        for (int i = 0; i < parts.length && valid; ++i) {
            valid = !parts[i].trim().equals("");
        }
        if (valid) {
            if (parts.length == 1) {
                this.setGroupId("org.walkmod");
                String artifactId = parts[0].trim();
                if (!artifactId.startsWith("walkmod-")) {
                    artifactId = "walkmod-" + artifactId;
                }
                if (!artifactId.endsWith("-plugin")) {
                    artifactId = artifactId + "-plugin";
                }
                this.setArtifactId(artifactId);
                this.setVersion("latest.integration");
            } else if (parts.length == 2) {
                this.setGroupId(parts[0].trim());
                this.setArtifactId(parts[1].trim());
                this.setVersion("latest.integration");
            } else {
                this.setGroupId(parts[0].trim());
                this.setArtifactId(parts[1].trim());
                this.setVersion(parts[2].trim());
            }
        } else {
            throw new IllegalArgumentException("The plugin identifier is not well defined. The expected format is [groupId:artifactId:version]");
        }
    }

    @Override
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object pc) {
        if (pc instanceof PluginConfig) {
            if (this.groupId != null && this.artifactId != null) {
                PluginConfig aux = (PluginConfig)pc;
                return this.groupId.equals(aux.getGroupId()) && this.artifactId.equals(aux.getArtifactId());
            }
            return false;
        }
        return false;
    }
}

