/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.entities.impl;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.walkmod.ChainAdapter;
import org.walkmod.ChainAdapterFactory;
import org.walkmod.ChainReader;
import org.walkmod.ChainWalker;
import org.walkmod.ChainWriter;
import org.walkmod.Options;
import org.walkmod.WalkmodCommand;
import org.walkmod.conf.ConfigurationProvider;
import org.walkmod.conf.ExecutionModeEnum;
import org.walkmod.conf.Initializer;
import org.walkmod.conf.entities.BeanDefinition;
import org.walkmod.conf.entities.ChainConfig;
import org.walkmod.conf.entities.Configuration;
import org.walkmod.conf.entities.InitializerConfig;
import org.walkmod.conf.entities.MergePolicyConfig;
import org.walkmod.conf.entities.PluginConfig;
import org.walkmod.conf.entities.PropertyDefinition;
import org.walkmod.conf.entities.ProviderConfig;
import org.walkmod.conf.entities.TransformationConfig;
import org.walkmod.conf.entities.impl.BeanDefinitionImpl;
import org.walkmod.conf.entities.impl.InitializerConfigImpl;
import org.walkmod.conf.entities.impl.PluginConfigImpl;
import org.walkmod.conf.entities.impl.PropertyDefinitionImpl;
import org.walkmod.exceptions.WalkModException;
import org.walkmod.impl.DefaultChainAdapterFactory;
import org.walkmod.merger.MergeEngine;
import org.walkmod.merger.MergePolicy;
import org.walkmod.walkers.VisitorMessage;
import org.walkmod.writers.Summary;

public class ConfigurationImpl
implements Configuration {
    private Map<String, Object> parameters;
    private Map<String, ChainConfig> chainConfigs;
    private BeanFactory beanFactory = null;
    private Collection<PluginConfig> plugins;
    private ClassLoader classLoader = null;
    private Collection<MergePolicyConfig> mergePolicies;
    private Map<String, MergeEngine> mergeEngines;
    private String defaultLanguage = null;
    private Collection<ProviderConfig> providers;
    private List<InitializerConfig> initializers;
    private List<String> modules;
    private BeanDefinitionRegistry beanDefinitionRegistry;
    private ExecutionModeEnum executionMode = ExecutionModeEnum.APPLY;
    public static Logger log = Logger.getLogger(ConfigurationImpl.class);

    public ConfigurationImpl() {
        this.parameters = new LinkedHashMap<String, Object>();
        this.chainConfigs = new LinkedHashMap<String, ChainConfig>();
        this.mergeEngines = new LinkedHashMap<String, MergeEngine>();
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(Map<String, Object> parameters) {
        if (parameters != null) {
            this.parameters = parameters;
        }
    }

    @Override
    public Collection<ChainConfig> getChainConfigs() {
        return this.chainConfigs.values();
    }

    @Override
    public void setChainConfigs(Collection<ChainConfig> chainConfigs) {
        this.chainConfigs.clear();
        for (ChainConfig current : chainConfigs) {
            current.setConfiguration(this);
            this.chainConfigs.put(current.getName(), current);
        }
    }

    @Override
    public boolean addChainConfig(ChainConfig architecture) {
        boolean result = this.chainConfigs.containsKey(architecture.getName());
        if (!result) {
            architecture.setConfiguration(this);
            this.chainConfigs.put(architecture.getName(), architecture);
        }
        return result;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    @Override
    public void preparePlugins() {
        List<InitializerConfig> list;
        Collection<ProviderConfig> providers;
        Collection<PluginConfig> pluginCfg = this.getPlugins();
        HashSet<String> plugins = new HashSet<String>();
        HashSet<String> previousPlugins = new HashSet<String>();
        if (pluginCfg == null || pluginCfg.isEmpty()) {
            pluginCfg = new LinkedList<PluginConfig>();
        } else {
            for (PluginConfig pc : pluginCfg) {
                previousPlugins.add(pc.getGroupId() + ":" + pc.getArtifactId());
            }
        }
        Collection<ChainConfig> chains = this.getChainConfigs();
        if (chains != null) {
            for (ChainConfig chainConfig : chains) {
                this.composeName(chainConfig.getReaderConfig().getType(), plugins);
                this.composeName(chainConfig.getWalkerConfig().getParserConfig().getType(), plugins);
                List<TransformationConfig> trans = chainConfig.getWalkerConfig().getTransformations();
                if (trans != null) {
                    for (TransformationConfig transformation : trans) {
                        String type = transformation.getType();
                        if (type.equals("script") || type.equals("template")) continue;
                        this.composeName(type, plugins);
                    }
                }
                this.composeName(chainConfig.getWriterConfig().getType(), plugins);
            }
        }
        if ((providers = this.getProviderConfigurations()) != null) {
            for (ProviderConfig provider : providers) {
                String type = provider.getType();
                this.composeName(type, plugins);
            }
        }
        if ((list = this.getInitializers()) != null) {
            for (InitializerConfig initializer : list) {
                plugins.add(initializer.getPluginGroupId() + ":walkmod-" + initializer.getPluginArtifactId() + "-plugin");
            }
        }
        for (String id : plugins) {
            if (previousPlugins.contains(id)) continue;
            String[] parts = id.split(":");
            PluginConfigImpl cfg = new PluginConfigImpl();
            cfg.setGroupId(parts[0].trim());
            cfg.setArtifactId(parts[1].trim());
            cfg.setVersion("latest.integration");
            pluginCfg.add(cfg);
        }
        this.setPlugins(pluginCfg);
    }

    private void composeName(String type, HashSet<String> plugins) {
        if (type != null && !type.startsWith("walkmod:commons")) {
            String aux;
            String[] parts = type.split(":");
            if (parts.length == 3) {
                if (!parts[1].startsWith("walkmod-")) {
                    parts[1] = "walkmod-" + parts[1];
                }
                if (!parts[1].endsWith("-plugin")) {
                    parts[1] = parts[1] + "-plugin";
                }
                plugins.add(parts[0] + ":" + parts[1]);
            } else if (parts.length <= 2 && (aux = parts[0].trim()).length() > 0) {
                plugins.add("org.walkmod:walkmod-" + aux + "-plugin");
            }
        }
    }

    @Override
    public Object getBean(String name, Map<?, ?> parameters) {
        Object result = null;
        if (name == null || "".equals(name)) {
            return result;
        }
        if (name.equals("script")) {
            name = "walkmod:commons:scripting";
        } else if (name.equals("template")) {
            name = "walkmod:commons:template";
        }
        if (this.beanFactory != null && this.beanFactory.containsBean(name)) {
            result = this.beanFactory.getBean(name);
        }
        if (result == null) {
            String fullName = "org.walkmod:walkmod-" + name + "-plugin:" + name;
            if (!name.contains(":") && this.beanFactory.containsBean(fullName)) {
                result = this.beanFactory.getBean(fullName);
            } else {
                String[] parts = name.split(":");
                if (parts.length == 2) {
                    String pluginId = parts[0].trim();
                    String beanId = parts[1].trim();
                    String compositeName = "org.walkmod:walkmod-" + pluginId + "-plugin:" + beanId;
                    if (pluginId.length() > 0 && beanId.length() > 0 && this.beanFactory.containsBean(compositeName)) {
                        result = this.beanFactory.getBean(compositeName);
                    }
                }
            }
        }
        if (result == null) {
            try {
                Class<?> clazz = this.getClassLoader().loadClass(name);
                result = clazz.newInstance();
            }
            catch (Exception e) {
                throw new WalkModException("Sorry, it is impossible to load the bean " + name + ". Please, assure that it is a valid class name and the library which contains it is in the classpath", e);
            }
        }
        if (result != null) {
            MutablePropertyValues pvs;
            BeanWrapperImpl bw = new BeanWrapperImpl(result);
            if (this.parameters != null) {
                pvs = new MutablePropertyValues(this.parameters);
                bw.setPropertyValues((PropertyValues)pvs, true, true);
            }
            if (parameters != null) {
                pvs = new MutablePropertyValues(parameters);
                bw.setPropertyValues((PropertyValues)pvs, true, true);
            }
        }
        return result;
    }

    @Override
    public void populate(Object element, Map<?, ?> parameters) {
        if (element != null) {
            BeanWrapperImpl bw = new BeanWrapperImpl(element);
            if (this.parameters != null) {
                bw.setPropertyValues(this.parameters);
            }
            bw.setPropertyValues(parameters);
        }
    }

    @Override
    public Collection<VisitorMessage> getVisitorMessages() {
        LinkedList<VisitorMessage> result = new LinkedList<VisitorMessage>();
        if (this.getChainConfigs() != null) {
            for (ChainConfig aqConfig : this.getChainConfigs()) {
                result.addAll(aqConfig.getWalkerConfig().getWalker().getVisitorMessages());
            }
        }
        return result;
    }

    @Override
    public Collection<PluginConfig> getPlugins() {
        return this.plugins;
    }

    @Override
    public void setPlugins(Collection<PluginConfig> plugins) {
        this.plugins = plugins;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return this.classLoader;
    }

    @Override
    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Collection<MergePolicyConfig> getMergePolicies() {
        return this.mergePolicies;
    }

    @Override
    public void setMergePolicies(Collection<MergePolicyConfig> mergePolicies) {
        this.mergePolicies = mergePolicies;
    }

    @Override
    public void setMergeEngines(Map<String, MergeEngine> mergeEngines) {
        this.mergeEngines = mergeEngines;
    }

    @Override
    public MergeEngine getMergeEngine(String name) {
        return this.mergeEngines.get(name);
    }

    @Override
    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    @Override
    public void setDefaultLanguage(String defaults) {
        this.defaultLanguage = defaults;
    }

    @Override
    public Collection<ProviderConfig> getProviderConfigurations() {
        return this.providers;
    }

    @Override
    public void setProviderConfigurations(Collection<ProviderConfig> providers) {
        this.providers = providers;
    }

    @Override
    public void setModules(List<String> modules) {
        this.modules = modules;
    }

    @Override
    public List<String> getModules() {
        return this.modules;
    }

    @Override
    public void setInitializers(List<InitializerConfig> initializers) {
        this.initializers = initializers;
    }

    @Override
    public List<InitializerConfig> getInitializers() {
        return this.initializers;
    }

    @Override
    public boolean containsBean(String beanId) {
        if (this.beanFactory != null) {
            if (!beanId.contains(":")) {
                return this.beanFactory.containsBean("org.walkmod:walkmod-" + beanId + "-plugin:" + beanId);
            }
            return this.beanFactory.containsBean(beanId);
        }
        return false;
    }

    @Override
    public List<BeanDefinition> getAvailableBeans(PluginConfig pc) {
        LinkedList<BeanDefinition> result = new LinkedList<BeanDefinition>();
        String[] names = this.beanDefinitionRegistry.getBeanDefinitionNames();
        if (names != null) {
            for (String name : names) {
                if (!name.startsWith(pc.getGroupId() + ":" + pc.getArtifactId())) continue;
                Object o = this.beanFactory.getBean(name);
                String classification = "transformation";
                if (o instanceof ChainReader) {
                    classification = "reader";
                } else if (o instanceof ChainWriter) {
                    classification = "writer";
                } else if (o instanceof ChainWalker) {
                    classification = "walker";
                } else if (o instanceof Initializer) {
                    classification = "initializer";
                } else if (o instanceof ConfigurationProvider) {
                    classification = "conf-provider";
                } else if (o instanceof MergePolicy) {
                    classification = "policy-entry";
                }
                String id = name;
                int index0 = "walkmod-".length();
                int index1 = pc.getArtifactId().indexOf("-plugin");
                if (index1 == -1) continue;
                id = pc.getArtifactId().substring(index0, index1);
                String uniqueFullName = pc.getGroupId() + ":" + pc.getArtifactId() + ":" + id;
                if (!name.equals(uniqueFullName)) {
                    if (this.beanDefinitionRegistry.isAlias(name)) continue;
                    String[] aliases = this.beanDefinitionRegistry.getAliases(name);
                    boolean add = true;
                    if (aliases != null) {
                        for (int i = 0; i < aliases.length && add; ++i) {
                            add = !aliases[i].equals(uniqueFullName);
                        }
                    }
                    if (add) {
                        result.add(new BeanDefinitionImpl(classification, name, this.beanDefinitionRegistry.getBeanDefinition(name).getDescription(), this.getProperties(o)));
                        continue;
                    }
                    result.add(new BeanDefinitionImpl(classification, id, this.beanDefinitionRegistry.getBeanDefinition(name).getDescription(), this.getProperties(o)));
                    continue;
                }
                result.add(new BeanDefinitionImpl(classification, id, this.beanDefinitionRegistry.getBeanDefinition(name).getDescription(), this.getProperties(o)));
            }
        }
        return result;
    }

    private List<PropertyDefinition> getProperties(Object o) {
        LinkedList<PropertyDefinition> result = new LinkedList<PropertyDefinition>();
        PropertyDescriptor[] properties = BeanUtils.getPropertyDescriptors(o.getClass());
        if (properties != null) {
            for (PropertyDescriptor pd : properties) {
                if (pd.getWriteMethod() == null) continue;
                String name = pd.getDisplayName();
                Class<?> clazz = pd.getPropertyType();
                String type = clazz.getSimpleName();
                String value = "";
                if (String.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || clazz.isPrimitive()) {
                    if (pd.getReadMethod() != null) {
                        try {
                            value = pd.getReadMethod().invoke(o, new Object[0]).toString();
                        }
                        catch (Exception exception) {}
                    } else {
                        Field[] fields = o.getClass().getDeclaredFields();
                        boolean found = false;
                        for (int i = 0; i < fields.length && !found; ++i) {
                            if (!fields[i].getName().equals(name)) continue;
                            found = true;
                            fields[i].setAccessible(true);
                            try {
                                value = fields[i].get(o).toString();
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                PropertyDefinitionImpl item = new PropertyDefinitionImpl(type, name, value);
                result.add(item);
            }
        }
        return result;
    }

    @Override
    public void setBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) {
        this.beanDefinitionRegistry = beanDefinitionRegistry;
    }

    @Override
    public ExecutionModeEnum getExecutionMode() {
        return this.executionMode;
    }

    @Override
    public void setExecutionMode(ExecutionModeEnum executionMode) {
        this.executionMode = executionMode;
    }

    @Override
    public void executeModuleChains(Options options, WalkmodCommand command, String ... chains) throws Exception {
        List<String> modules = this.getModules();
        if (modules != null && !modules.isEmpty()) {
            for (String module : modules) {
                File aux = new File(module).getAbsoluteFile();
                if (aux.isDirectory()) {
                    if (options.isVerbose()) {
                        log.info((Object)("** MODULE " + aux.getAbsoluteFile() + " [ok] **"));
                    }
                    command.execute(options, aux, chains);
                    continue;
                }
                log.error((Object)("The module " + aux.getAbsolutePath() + " is not an existing directory"));
            }
        }
    }

    @Override
    public void executeAllChains(Options options, ChainAdapterFactory apf) {
        Collection<ChainConfig> tcgfs = this.getChainConfigs();
        if (tcgfs != null) {
            long startTime;
            if (options.isVerbose()) {
                log.info((Object)"** STARTING TRANSFORMATIONS CHAINS **");
                System.out.print("----------------------------------------");
                System.out.println("----------------------------------------");
            }
            long endTime = startTime = System.currentTimeMillis();
            DecimalFormat myFormatter = new DecimalFormat("###.###");
            SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", Locale.US);
            int num = 0;
            Iterator<ChainConfig> it = tcgfs.iterator();
            int pos = 1;
            while (it.hasNext()) {
                ChainConfig tcfg = it.next();
                if (tcgfs.size() > 1 && options.isVerbose()) {
                    String label = "";
                    label = tcfg.getName() != null && !tcfg.getName().startsWith("chain_") ? "[" + tcfg.getName() + "](" + pos + "/" + tcgfs.size() + ") " : "(" + pos + "/" + tcgfs.size() + ")";
                    log.info((Object)("TRANSFORMATION CHAIN " + label));
                    System.out.println();
                }
                try {
                    if (options.getIncludes() != null) {
                        String[] includes = options.getIncludes().toArray(new String[options.getIncludes().size()]);
                        tcfg.getReaderConfig().setIncludes(includes);
                    }
                    if (options.getExcludes() != null) {
                        String[] excludes = options.getExcludes().toArray(new String[options.getExcludes().size()]);
                        tcfg.getReaderConfig().setExcludes(excludes);
                    }
                    ChainAdapter ap = apf.createChainProxy(this, tcfg.getName());
                    ap.execute();
                    num += ap.getWalkerAdapter().getWalker().getNumModifications();
                    ++pos;
                    if (options.isVerbose()) {
                        if (Summary.getInstance().getWrittenFiles().isEmpty()) {
                            log.info((Object)"**No sources changed**");
                        }
                        if (it.hasNext()) {
                            System.out.println();
                        }
                    }
                }
                catch (Throwable e) {
                    if (options.isVerbose()) {
                        endTime = System.currentTimeMillis();
                        double time = 0.0;
                        if (endTime > startTime) {
                            time = (double)(endTime - startTime) / 1000.0;
                        }
                        String timeMsg = myFormatter.format(time);
                        if (num != 0) {
                            System.out.print("----------------------------------------");
                            System.out.println("----------------------------------------");
                        }
                        log.info((Object)"TRANSFORMATION CHAIN FAILS");
                        System.out.println();
                        System.out.print("----------------------------------------");
                        System.out.println("----------------------------------------");
                        log.info((Object)("Total time: " + timeMsg + " seconds"));
                        log.info((Object)("Finished at: " + df.format(new Date())));
                        log.info((Object)("Final memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + " M/ " + Runtime.getRuntime().totalMemory() / 0x100000L + " M"));
                        System.out.print("----------------------------------------");
                        System.out.println("----------------------------------------");
                        log.info((Object)"Please, see the walkmod log file for details");
                        if (options.isPrintErrors()) {
                            log.error((Object)("TRANSFORMATION CHAIN (" + tcfg.getName() + ") FAILS"), e);
                        } else {
                            log.error((Object)("TRANSFORMATION CHAIN (" + tcfg.getName() + ") FAILS. Execute walkmod with -e to see the error details."));
                        }
                        if (options.isThrowException()) {
                            RuntimeException re = new RuntimeException();
                            re.setStackTrace(e.getStackTrace());
                            throw re;
                        }
                    } else {
                        throw new WalkModException(e);
                    }
                    return;
                }
                if (it.hasNext() || tcgfs.size() < pos) continue;
                LinkedList<ChainConfig> aux = new LinkedList<ChainConfig>(tcgfs);
                it = aux.listIterator(pos - 1);
            }
            if (options.isVerbose()) {
                endTime = System.currentTimeMillis();
                double time = 0.0;
                if (endTime > startTime) {
                    time = (double)(endTime - startTime) / 1000.0;
                }
                String timeMsg = myFormatter.format(time);
                if (num != 0) {
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                }
                System.out.println();
                log.info((Object)"TRANSFORMATION CHAIN SUCCESS");
                System.out.print("----------------------------------------");
                System.out.println("----------------------------------------");
                log.info((Object)("Total time: " + timeMsg + " seconds"));
                log.info((Object)("Finished at: " + df.format(new Date())));
                log.info((Object)("Final memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + " M/ " + Runtime.getRuntime().totalMemory() / 0x100000L + " M"));
                log.info((Object)("Total modified files: " + num));
                System.out.print("----------------------------------------");
                System.out.println("----------------------------------------");
            }
        }
    }

    @Override
    public void executeChain(String userDir, Options options, ChainAdapterFactory apf, String name) {
        ChainAdapter ap;
        Collection<ChainConfig> chains;
        if ((options.getIncludes() != null || options.getExcludes() != null) && (chains = this.getChainConfigs()) != null) {
            for (ChainConfig cc : chains) {
                if (options.getIncludes() != null) {
                    String[] includes = options.getIncludes().toArray(new String[options.getIncludes().size()]);
                    cc.getReaderConfig().setIncludes(includes);
                }
                if (options.getExcludes() == null) continue;
                String[] excludes = options.getExcludes().toArray(new String[options.getExcludes().size()]);
                cc.getReaderConfig().setExcludes(excludes);
            }
        }
        if ((ap = apf.createChainProxy(this, name)) == null) {
            if (options.isVerbose()) {
                log.error((Object)("The chain " + name + " is not found"));
                System.out.print("----------------------------------------");
                System.out.println("----------------------------------------");
            }
        } else {
            long startTime;
            long endTime = startTime = System.currentTimeMillis();
            DecimalFormat myFormatter = new DecimalFormat("###.###");
            SimpleDateFormat df = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss", Locale.US);
            if (options.isVerbose()) {
                log.info((Object)("** THE TRANSFORMATION CHAIN " + name + " STARTS **"));
                System.out.print("----------------------------------------");
                System.out.println("----------------------------------------");
            }
            int num = 0;
            try {
                int size = this.getChainConfigs().size();
                ap.execute();
                if (this.getChainConfigs().size() > size) {
                    LinkedList<ChainConfig> aux = new LinkedList<ChainConfig>(this.getChainConfigs());
                    ListIterator<ChainConfig> it = aux.listIterator(size);
                    while (it.hasNext()) {
                        ChainConfig tcfg = (ChainConfig)it.next();
                        ChainAdapter auxAp = apf.createChainProxy(this, tcfg.getName());
                        auxAp.execute();
                    }
                }
                num = ap.getWalkerAdapter().getWalker().getNumModifications();
                if (options.isVerbose()) {
                    endTime = System.currentTimeMillis();
                    double time = 0.0;
                    if (endTime > startTime) {
                        time = (double)(endTime - startTime) / 1000.0;
                    }
                    String timeMsg = myFormatter.format(time);
                    if (num != 0) {
                        System.out.print("----------------------------------------");
                        System.out.println("----------------------------------------");
                    } else if (Summary.getInstance().getWrittenFiles().isEmpty()) {
                        log.info((Object)"**No sources changed**");
                    }
                    System.out.println();
                    log.info((Object)"TRANSFORMATION CHAIN SUCCESS");
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    log.info((Object)("Total time: " + timeMsg + " seconds"));
                    log.info((Object)("Finished at: " + df.format(new Date())));
                    log.info((Object)("Final memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + " M/ " + Runtime.getRuntime().totalMemory() / 0x100000L + " M"));
                    if (ap.getWalkerAdapter().getWalker().reportChanges()) {
                        log.info((Object)("Total modified files: " + num));
                    }
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                }
            }
            catch (Throwable e) {
                System.setProperty("user.dir", userDir);
                if (options.isVerbose()) {
                    endTime = System.currentTimeMillis();
                    double time = 0.0;
                    if (endTime > startTime) {
                        time = (double)(endTime - startTime) / 1000.0;
                    }
                    String timeMsg = myFormatter.format(time);
                    if (num != 0) {
                        System.out.print("----------------------------------------");
                        System.out.println("----------------------------------------");
                    }
                    log.info((Object)"TRANSFORMATION CHAIN FAILS");
                    System.out.println();
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    log.info((Object)("Total time: " + timeMsg + " seconds"));
                    log.info((Object)("Finished at: " + df.format(new Date())));
                    log.info((Object)("Final memory: " + Runtime.getRuntime().freeMemory() / 0x100000L + " M/ " + Runtime.getRuntime().totalMemory() / 0x100000L + " M"));
                    System.out.print("----------------------------------------");
                    System.out.println("----------------------------------------");
                    log.info((Object)"Please, see the walkmod log file for details");
                    if (options.isPrintErrors()) {
                        log.error((Object)("TRANSFORMATION CHAIN (" + name + ") FAILS"), e);
                    } else {
                        log.error((Object)("TRANSFORMATION CHAIN (" + name + ") FAILS. Execute walkmod with -e to see the error details."));
                    }
                } else {
                    throw new WalkModException(e);
                }
                return;
            }
        }
    }

    @Override
    public void execute(String userDir, Options options, String ... chains) {
        DefaultChainAdapterFactory apf = new DefaultChainAdapterFactory();
        Summary.getInstance().clear();
        Collection<ChainConfig> chainCfgs = this.getChainConfigs();
        if (chainCfgs != null && !chainCfgs.isEmpty()) {
            if (chains == null || chains.length == 0) {
                this.executeAllChains(options, apf);
            } else {
                for (String chain : chains) {
                    this.executeChain(userDir, options, apf, chain);
                }
            }
        }
    }

    @Override
    public ChainConfig getChainConfig(String chainConfig) {
        return this.chainConfigs.get(chainConfig);
    }

    @Override
    public void prepareInitializers() {
        InitializerConfigImpl init = null;
        File pom = new File("pom.xml").getAbsoluteFile();
        if (pom.exists()) {
            init = new InitializerConfigImpl();
            init.setType("maven-initializer");
        } else {
            File gradle = new File("settings.gradle");
            if (gradle.exists()) {
                init = new InitializerConfigImpl();
                init.setType("gradle-initializer");
            } else {
                gradle = new File("build.gradle");
                if (gradle.exists()) {
                    init = new InitializerConfigImpl();
                    init.setType("gradle-initializer");
                }
            }
        }
        if (init != null) {
            List<InitializerConfig> list = this.getInitializers();
            if (list == null) {
                list = new LinkedList<InitializerConfig>();
            }
            list.add(init);
            this.setInitializers(list);
        }
    }
}

