/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.conf.entities;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.walkmod.conf.entities.ReaderConfig;
import org.walkmod.conf.entities.TransformationConfig;
import org.walkmod.conf.entities.WalkerConfig;
import org.walkmod.conf.entities.WriterConfig;
import org.walkmod.conf.entities.impl.ParserConfigImpl;
import org.walkmod.conf.entities.impl.TransformationConfigImpl;
import org.walkmod.conf.entities.impl.WalkerConfigImpl;
import org.walkmod.conf.entities.impl.WriterConfigImpl;

public class JSONConfigParser {
    public ReaderConfig getReader(JsonNode reader) {
        ReaderConfig model = new ReaderConfig();
        if (reader.has("path")) {
            model.setPath(reader.get("path").asText());
        }
        if (reader.has("type")) {
            model.setType(reader.get("type").asText());
        }
        if (reader.has("includes")) {
            JsonNode includesJson = reader.get("includes");
            model.setIncludes(this.getFileSet(includesJson));
        }
        if (reader.has("excludes")) {
            JsonNode excludesJson = reader.get("excludes");
            model.setExcludes(this.getFileSet(excludesJson));
        }
        model.setParameters(this.getParams(reader));
        return model;
    }

    public WalkerConfig getWalker(JsonNode current) {
        WalkerConfigImpl walkerCfg = new WalkerConfigImpl();
        if (current.has("type")) {
            walkerCfg.setType(current.get("type").asText());
        }
        if (current.has("parser")) {
            ParserConfigImpl parserCfg = new ParserConfigImpl();
            JsonNode parserNode = current.get("parser");
            parserCfg.setType(parserNode.get("type").asText());
            parserCfg.setParameters(this.getParams(parserNode));
            walkerCfg.setParserConfig(parserCfg);
        }
        walkerCfg.setTransformations(this.getTransformationCfgs(current));
        if (current.has("root-namespace")) {
            walkerCfg.setRootNamespace(current.get("root-namespace").asText());
        }
        walkerCfg.setParams(this.getParams(current));
        return walkerCfg;
    }

    public List<TransformationConfig> getTransformationCfgs(JsonNode current) {
        if (current.has("transformations")) {
            LinkedList<TransformationConfig> transList = new LinkedList<TransformationConfig>();
            for (JsonNode item : current.get("transformations")) {
                TransformationConfigImpl trans = new TransformationConfigImpl();
                if (item.has("type")) {
                    trans.setType(item.get("type").asText());
                }
                if (item.has("name")) {
                    trans.setName(item.get("name").asText());
                }
                if (item.has("merge-policy")) {
                    trans.setMergePolicy(item.get("merge-policy").asText());
                }
                if (item.has("isMergeable")) {
                    trans.isMergeable(item.get("isMergeable").asBoolean());
                }
                trans.setParameters(this.getParams(item));
                transList.add(trans);
            }
            return transList;
        }
        return null;
    }

    public WriterConfig getWriter(JsonNode writer) {
        WriterConfigImpl model = new WriterConfigImpl();
        if (writer.has("path")) {
            model.setPath(writer.get("path").asText());
        }
        if (writer.has("type")) {
            model.setType(writer.get("type").asText());
        }
        if (writer.has("includes")) {
            JsonNode includesJson = writer.get("includes");
            model.setIncludes(this.getFileSet(includesJson));
        }
        if (writer.has("excludes")) {
            JsonNode excludesJson = writer.get("excludes");
            model.setExcludes(this.getFileSet(excludesJson));
        }
        model.setParams(this.getParams(writer));
        return model;
    }

    public String[] getFileSet(JsonNode parent) {
        String[] includes = new String[parent.size()];
        Iterator includesIt = parent.iterator();
        int j = 0;
        while (includesIt.hasNext()) {
            JsonNode item = (JsonNode)includesIt.next();
            includes[j] = item.asText();
            ++j;
        }
        return includes;
    }

    public Map<String, Object> getParams(JsonNode next) {
        if (next.has("params")) {
            Iterator it2 = next.get("params").fields();
            HashMap<String, Object> params = new HashMap<String, Object>();
            while (it2.hasNext()) {
                Map.Entry param = (Map.Entry)it2.next();
                JsonNode value = (JsonNode)param.getValue();
                if (value.isTextual()) {
                    params.put((String)param.getKey(), value.asText());
                } else if (value.isInt()) {
                    params.put((String)param.getKey(), value.asInt());
                } else if (value.isBoolean()) {
                    params.put((String)param.getKey(), value.asBoolean());
                } else if (value.isDouble() || value.isFloat() || value.isBigDecimal()) {
                    params.put((String)param.getKey(), value.asDouble());
                } else if (value.isLong() || value.isBigInteger()) {
                    params.put((String)param.getKey(), value.asLong());
                } else {
                    params.put((String)param.getKey(), value);
                }
                params.put((String)param.getKey(), ((JsonNode)param.getValue()).asText());
            }
            return params;
        }
        return null;
    }
}

